/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSliceOutput {
    @Test
    public void testAppendByte() throws Exception {
        for (int i = -128; i <= 127; ++i) {
            Slice actual = new DynamicSliceOutput(1).appendByte(i).slice();
            Slice expected = Slices.wrappedBuffer((byte[])new byte[]{(byte)i});
            Assert.assertEquals((Object)actual, (Object)expected);
        }
    }

    @Test
    public void testAppendUnsignedByte() throws Exception {
        for (int i = 0; i < 256; ++i) {
            Slice actual = new DynamicSliceOutput(1).appendByte(i).slice();
            Slice expected = Slices.wrappedBuffer((byte[])new byte[]{(byte)i});
            Assert.assertEquals((Object)actual, (Object)expected);
        }
    }

    @Test
    public void testAppendByteTruncation() throws Exception {
        for (int i = 256; i < 512; ++i) {
            Slice actual = new DynamicSliceOutput(1).appendByte(i).slice();
            Slice expected = Slices.wrappedBuffer((byte[])new byte[]{(byte)i});
            Assert.assertEquals((Object)actual, (Object)expected);
        }
    }

    @Test
    public void testAppendMultiple() throws Exception {
        Slice actual = new DynamicSliceOutput(1).appendByte(0).appendByte(1).appendByte(2).appendByte(3).appendByte(4).slice();
        Slice expected = Slices.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4});
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testRetainedSize() throws Exception {
        int sliceOutputInstanceSize = ClassLayout.parseClass(DynamicSliceOutput.class).instanceSize();
        DynamicSliceOutput output = new DynamicSliceOutput(10);
        int originalRetainedSize = output.getRetainedSize();
        Assert.assertEquals((int)originalRetainedSize, (int)(sliceOutputInstanceSize + output.getUnderlyingSlice().getRetainedSize()));
        Assert.assertEquals((int)output.size(), (int)0);
        output.appendLong(0L);
        output.appendShort(0);
        Assert.assertEquals((int)output.getRetainedSize(), (int)originalRetainedSize);
        Assert.assertEquals((int)output.size(), (int)10);
    }
}

