/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import io.airlift.slice.ByteArrays;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.ByteOrder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestByteArrays {
    @Test
    public void testReading() {
        Assert.assertEquals((Object)ByteOrder.nativeOrder(), (Object)ByteOrder.LITTLE_ENDIAN);
        byte[] bytes = new byte[10];
        Slice slice = Slices.wrappedBuffer((byte[])bytes);
        slice.setInt(0, -559038737);
        slice.setInt(4, -889275714);
        Assert.assertEquals((byte[])slice.getBytes(), (byte[])new byte[]{-17, -66, -83, -34, -66, -70, -2, -54, 0, 0});
        Assert.assertEquals((short)ByteArrays.getShort((byte[])bytes, (int)0), (short)-16657);
        Assert.assertEquals((short)ByteArrays.getShort((byte[])bytes, (int)1), (short)-21058);
        Assert.assertEquals((short)ByteArrays.getShort((byte[])bytes, (int)2), (short)-8531);
        Assert.assertEquals((short)ByteArrays.getShort((byte[])bytes, (int)3), (short)-16674);
        Assert.assertEquals((int)ByteArrays.getInt((byte[])bytes, (int)0), (int)-559038737);
        Assert.assertEquals((int)ByteArrays.getInt((byte[])bytes, (int)1), (int)-1092702786);
        Assert.assertEquals((int)ByteArrays.getInt((byte[])bytes, (int)2), (int)-1161896275);
        Assert.assertEquals((int)ByteArrays.getInt((byte[])bytes, (int)3), (int)-21315874);
        Assert.assertEquals((int)ByteArrays.getInt((byte[])bytes, (int)4), (int)-889275714);
        Assert.assertEquals((long)ByteArrays.getLong((byte[])bytes, (int)0), (long)-3819410105021120785L);
        Assert.assertEquals((long)ByteArrays.getLong((byte[])bytes, (int)1), (long)57138023315189182L);
        Assert.assertEquals((long)ByteArrays.getLong((byte[])bytes, (int)2), (long)223195403574957L);
        Assert.assertEquals((Object)Float.valueOf(ByteArrays.getFloat((byte[])bytes, (int)0)), (Object)Float.valueOf(Float.intBitsToFloat(-559038737)));
        Assert.assertEquals((Object)Float.valueOf(ByteArrays.getFloat((byte[])bytes, (int)1)), (Object)Float.valueOf(Float.intBitsToFloat(-1092702786)));
        Assert.assertEquals((Object)Float.valueOf(ByteArrays.getFloat((byte[])bytes, (int)2)), (Object)Float.valueOf(Float.intBitsToFloat(-1161896275)));
        Assert.assertEquals((Object)Float.valueOf(ByteArrays.getFloat((byte[])bytes, (int)3)), (Object)Float.valueOf(Float.intBitsToFloat(-21315874)));
        Assert.assertEquals((Object)Float.valueOf(ByteArrays.getFloat((byte[])bytes, (int)4)), (Object)Float.valueOf(Float.intBitsToFloat(-889275714)));
        Assert.assertEquals((Object)ByteArrays.getDouble((byte[])bytes, (int)0), (Object)Double.longBitsToDouble(-3819410105021120785L));
        Assert.assertEquals((Object)ByteArrays.getDouble((byte[])bytes, (int)1), (Object)Double.longBitsToDouble(57138023315189182L));
        Assert.assertEquals((Object)ByteArrays.getDouble((byte[])bytes, (int)2), (Object)Double.longBitsToDouble(223195403574957L));
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testReadingShortBounds() {
        ByteArrays.getShort((byte[])new byte[3], (int)2);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testReadingIntBounds() {
        ByteArrays.getInt((byte[])new byte[5], (int)2);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testReadingLongBounds() {
        ByteArrays.getLong((byte[])new byte[9], (int)2);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testReadingFloatBounds() {
        ByteArrays.getFloat((byte[])new byte[5], (int)2);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testReadingDoubleBounds() {
        ByteArrays.getDouble((byte[])new byte[9], (int)2);
    }
}

