/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestXxHash64 {
    private static final long PRIME = 2654435761L;
    private final Slice buffer = Slices.allocate((int)101);

    public TestXxHash64() {
        long value = 2654435761L;
        for (int i = 0; i < this.buffer.length(); ++i) {
            this.buffer.setByte(i, (int)((byte)(value >> 24)));
            value *= value;
        }
    }

    @Test
    public void testSanity() throws Exception {
        Assert.assertEquals((long)XxHash64.hash((long)0L, (Slice)this.buffer, (int)0, (int)1), (long)5750596776143442648L);
        Assert.assertEquals((long)XxHash64.hash((long)2654435761L, (Slice)this.buffer, (int)0, (int)1), (long)8329478753618994979L);
        Assert.assertEquals((long)XxHash64.hash((long)0L, (Slice)this.buffer, (int)0, (int)4), (long)-7901876112562082063L);
        Assert.assertEquals((long)XxHash64.hash((long)2654435761L, (Slice)this.buffer, (int)0, (int)4), (long)708753852729961291L);
        Assert.assertEquals((long)XxHash64.hash((long)0L, (Slice)this.buffer, (int)0, (int)8), (long)-626931337744172849L);
        Assert.assertEquals((long)XxHash64.hash((long)2654435761L, (Slice)this.buffer, (int)0, (int)8), (long)-7186417346120842555L);
        Assert.assertEquals((long)XxHash64.hash((long)0L, (Slice)this.buffer, (int)0, (int)14), (long)-3460297540090709443L);
        Assert.assertEquals((long)XxHash64.hash((long)2654435761L, (Slice)this.buffer, (int)0, (int)14), (long)6599481375206459851L);
        Assert.assertEquals((long)XxHash64.hash((long)0L, (Slice)this.buffer, (int)0, (int)32), (long)-5812084625956540946L);
        Assert.assertEquals((long)XxHash64.hash((long)2654435761L, (Slice)this.buffer, (int)0, (int)32), (long)-2545780413506618609L);
        Assert.assertEquals((long)XxHash64.hash((long)0L, (Slice)this.buffer), (long)1057031117799454893L);
        Assert.assertEquals((long)XxHash64.hash((long)2654435761L, (Slice)this.buffer), (long)-3844287129753543135L);
    }

    @Test
    public void testEmpty() throws Exception {
        Assert.assertEquals((long)XxHash64.hash((long)0L, (Slice)Slices.EMPTY_SLICE), (long)-1205034819632174695L);
    }

    @Test
    public void testHashLong() throws Exception {
        Assert.assertEquals((long)XxHash64.hash((long)this.buffer.getLong(0)), (long)XxHash64.hash((Slice)this.buffer, (int)0, (int)8));
    }
}

