/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import io.airlift.slice.JvmUtils;
import io.airlift.slice.Slice;
import io.airlift.slice.UnsafeSliceFactory;
import java.nio.ByteBuffer;
import java.security.Permission;
import org.testng.Assert;
import org.testng.annotations.Test;
import sun.nio.ch.DirectBuffer;

public class TestUnsafeSliceFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRawAddress() throws Exception {
        UnsafeSliceFactory factory = UnsafeSliceFactory.getInstance();
        int size = 100;
        long address = JvmUtils.unsafe.allocateMemory(size);
        try {
            int i;
            Slice slice = factory.newSlice(address, size);
            for (i = 0; i < size; i += 4) {
                slice.setInt(i, i);
            }
            for (i = 0; i < size; i += 4) {
                Assert.assertEquals((int)slice.getInt(i), (int)i);
            }
        }
        finally {
            JvmUtils.unsafe.freeMemory(address);
        }
    }

    @Test
    public void testRawAddressWithReference() throws Exception {
        ByteBuffer buffer = ByteBuffer.allocateDirect(100);
        Assert.assertTrue((boolean)(buffer instanceof DirectBuffer));
        long address = ((DirectBuffer)((Object)buffer)).address();
        UnsafeSliceFactory factory = UnsafeSliceFactory.getInstance();
        Slice slice = factory.newSlice(address, buffer.capacity(), (Object)buffer);
        slice.setInt(32, -559038737);
        Assert.assertEquals((int)slice.getInt(32), (int)-559038737);
    }

    @Test(expectedExceptions={SecurityException.class})
    public void testSecurity() throws Exception {
        SecurityManager saved = System.getSecurityManager();
        System.setSecurityManager(new SecurityManager(){

            @Override
            public void checkPermission(Permission perm) {
                if (perm.getName().equals("suppressAccessChecks")) {
                    throw new SecurityException();
                }
            }
        });
        try {
            UnsafeSliceFactory.getInstance();
            Assert.fail((String)"expected SecurityException");
        }
        finally {
            System.setSecurityManager(saved);
        }
    }
}

