/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.ByteBuffer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSlices {
    @Test
    public void testWrapDirectBuffer() throws Exception {
        TestSlices.testWrapping(ByteBuffer.allocateDirect(50));
    }

    @Test
    public void testWrapHeapBuffer() throws Exception {
        TestSlices.testWrapping(ByteBuffer.allocate(50));
    }

    private static void testWrapping(ByteBuffer buffer) {
        int i;
        for (int i2 = 0; i2 < 50; ++i2) {
            buffer.put((byte)i2);
        }
        buffer.rewind();
        Slice slice = Slices.wrappedBuffer((ByteBuffer)buffer);
        Assert.assertEquals((int)slice.length(), (int)50);
        for (i = 0; i < 50; ++i) {
            Assert.assertEquals((int)slice.getByte(i), (int)i);
        }
        buffer.position(10).limit(30);
        slice = Slices.wrappedBuffer((ByteBuffer)buffer);
        Assert.assertEquals((int)slice.length(), (int)20);
        for (i = 0; i < 20; ++i) {
            Assert.assertEquals((int)slice.getByte(i), (int)(i + 10));
        }
        buffer = buffer.slice();
        slice = Slices.wrappedBuffer((ByteBuffer)buffer);
        Assert.assertEquals((int)slice.length(), (int)20);
        for (i = 0; i < 20; ++i) {
            Assert.assertEquals((int)slice.getByte(i), (int)(i + 10));
        }
    }
}

