/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSlice {
    @Test
    public void testFillAndClear() {
        for (int size = 0; size < 100; size = (int)((byte)(size + 1))) {
            int i;
            Slice slice = this.allocate(size);
            for (i = 0; i < slice.length(); ++i) {
                Assert.assertEquals((byte)slice.getByte(i), (byte)0);
            }
            slice.fill((byte)-91);
            for (i = 0; i < slice.length(); ++i) {
                Assert.assertEquals((byte)slice.getByte(i), (byte)-91);
            }
            slice.clear();
            for (i = 0; i < slice.length(); ++i) {
                Assert.assertEquals((byte)slice.getByte(i), (byte)0);
            }
        }
    }

    @Test
    public void testEqualsHashCodeCompare() {
        for (int size = 0; size < 100; ++size) {
            Slice slice = this.allocate(size);
            TestSlice.assertSlicesEquals(slice, slice);
            Slice other = this.allocate(size);
            TestSlice.assertSlicesEquals(slice, other);
            slice = this.allocate(size);
            slice.fill((byte)-91);
            TestSlice.assertSlicesEquals(slice, slice);
            other = this.allocate(size);
            other.fill((byte)-91);
            TestSlice.assertSlicesEquals(slice, other);
            Assert.assertNotEquals((Object)slice, (Object)new Object());
            Assert.assertNotEquals((Object)new Object(), (Object)slice);
            Slice oneBigger = this.allocate(size + 1);
            oneBigger.fill((byte)-91);
            Assert.assertNotEquals((Object)slice, (Object)oneBigger);
            Assert.assertNotEquals((Object)oneBigger, (Object)slice);
            Assert.assertTrue((slice.compareTo(oneBigger) < 0 ? 1 : 0) != 0);
            Assert.assertTrue((oneBigger.compareTo(slice) > 0 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)slice.equals(0, size, oneBigger, 0, size + 1));
            Assert.assertFalse((boolean)oneBigger.equals(0, size + 1, slice, 0, size));
            Assert.assertTrue((slice.compareTo(0, size, oneBigger, 0, size + 1) < 0 ? 1 : 0) != 0);
            Assert.assertTrue((oneBigger.compareTo(0, size + 1, slice, 0, size) > 0 ? 1 : 0) != 0);
            for (int i = 1; i < slice.length(); ++i) {
                slice.setByte(i - 1, 165);
                Assert.assertTrue((boolean)slice.equals(i - 1, size - i, other, i - 1, size - i));
                slice.setByte(i, 255);
                Assert.assertNotEquals((Object)slice, (Object)other);
                Assert.assertFalse((boolean)slice.equals(i, size - i, other, i, size - i));
                Assert.assertTrue((slice.compareTo(0, size, oneBigger, 0, size + 1) > 0 ? 1 : 0) != 0);
            }
            if (slice.length() <= 0) continue;
            Assert.assertNotEquals((Object)slice, (Object)Slices.EMPTY_SLICE);
            Assert.assertNotEquals((Object)Slices.EMPTY_SLICE, (Object)slice);
            Assert.assertFalse((boolean)slice.equals(0, size, Slices.EMPTY_SLICE, 0, 0));
            Assert.assertFalse((boolean)Slices.EMPTY_SLICE.equals(0, 0, slice, 0, size));
            Assert.assertTrue((slice.compareTo(0, size, Slices.EMPTY_SLICE, 0, 0) > 0 ? 1 : 0) != 0);
            Assert.assertTrue((Slices.EMPTY_SLICE.compareTo(0, 0, slice, 0, size) < 0 ? 1 : 0) != 0);
            try {
                slice.equals(0, size, Slices.EMPTY_SLICE, 0, size);
                Assert.fail((String)"expected IndexOutOfBoundsException");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                Slices.EMPTY_SLICE.equals(0, size, slice, 0, size);
                Assert.fail((String)"expected IndexOutOfBoundsException");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                slice.compareTo(0, size, Slices.EMPTY_SLICE, 0, size);
                Assert.fail((String)"expected IndexOutOfBoundsException");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                Slices.EMPTY_SLICE.compareTo(0, size, slice, 0, size);
                Assert.fail((String)"expected IndexOutOfBoundsException");
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    private static void assertSlicesEquals(Slice slice, Slice other) {
        int i;
        int size = slice.length();
        Assert.assertEquals((Object)slice, (Object)other);
        Assert.assertTrue((boolean)slice.equals(0, size, other, 0, size));
        Assert.assertEquals((int)slice.hashCode(), (int)other.hashCode());
        Assert.assertEquals((int)slice.hashCode(), (int)other.hashCode(0, size));
        Assert.assertEquals((int)slice.compareTo(other), (int)0);
        Assert.assertEquals((int)slice.compareTo(0, size, other, 0, size), (int)0);
        for (i = 0; i < slice.length(); ++i) {
            Assert.assertTrue((boolean)slice.equals(i, size - i, other, i, size - i));
            Assert.assertEquals((int)slice.hashCode(i, size - i), (int)other.hashCode(i, size - i));
            Assert.assertEquals((int)slice.compareTo(i, size - i, other, i, size - i), (int)0);
        }
        for (i = 0; i < slice.length(); ++i) {
            Assert.assertTrue((boolean)slice.equals(0, size - i, other, 0, size - i));
            Assert.assertEquals((int)slice.hashCode(0, size - i), (int)other.hashCode(0, size - i));
            Assert.assertEquals((int)slice.compareTo(0, size - i, other, 0, size - i), (int)0);
        }
    }

    @Test
    public void testToString() {
        Assert.assertEquals((String)Slices.copiedBuffer((String)"apple", (Charset)StandardCharsets.UTF_8).toString(StandardCharsets.UTF_8), (String)"apple");
        for (int size = 0; size < 100; ++size) {
            for (int index = 0; index < size; ++index) {
                TestSlice.assertToStrings(this.allocate(size), index);
            }
        }
    }

    @Test
    public void testUtf8Conversion() {
        String s = "apple \u2603 snowman";
        Slice slice = Slices.copiedBuffer((String)s, (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((Object)Slices.utf8Slice((String)s), (Object)slice);
        Assert.assertEquals((String)slice.toStringUtf8(), (String)s);
        Assert.assertEquals((String)Slices.utf8Slice((String)s).toStringUtf8(), (String)s);
    }

    private static void assertToStrings(Slice slice, int index) {
        slice.fill((byte)-1);
        char[] chars = new char[(slice.length() - index) / 2];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (char)(97 + i % 26);
        }
        String string = new String(chars);
        Slice value = Slices.copiedBuffer((String)string, (Charset)StandardCharsets.UTF_8);
        slice.setBytes(index, value);
        Assert.assertEquals((String)slice.toString(index, value.length(), StandardCharsets.UTF_8), (String)string);
        for (int length = 0; length < value.length(); ++length) {
            slice.fill((byte)-1);
            slice.setBytes(index, value, 0, length);
            Assert.assertEquals((String)slice.toString(index, length, StandardCharsets.UTF_8), (String)string.substring(0, length));
        }
    }

    @Test
    public void testByte() {
        for (int size = 0; size < 100; size = (int)((byte)(size + 1))) {
            for (byte index = 0; index < size - 1; index = (byte)(index + 1)) {
                TestSlice.assertByte(this.allocate(size), index);
            }
        }
    }

    private static void assertByte(Slice slice, byte index) {
        slice.fill((byte)-1);
        slice.setByte((int)index, 165);
        Assert.assertEquals((int)slice.getUnsignedByte((int)index), (int)165);
        slice.setByte((int)index, 165);
        Assert.assertEquals((byte)slice.getByte((int)index), (byte)-91);
        try {
            slice.getByte(-1);
            Assert.fail((String)"expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            slice.getByte(slice.length() - 1 + 1);
            Assert.fail((String)"expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            slice.getByte(slice.length());
            Assert.fail((String)"expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            slice.getByte(slice.length() + 1);
            Assert.fail((String)"expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testShort() {
        for (int size = 0; size < 100; size = (int)((short)(size + 1))) {
            for (short index = 0; index < size - 2; index = (short)(index + 1)) {
                TestSlice.assertShort(this.allocate(size), index);
            }
        }
    }

    private static void assertShort(Slice slice, short index) {
        slice.fill((byte)-1);
        slice.setShort((int)index, 43605);
        Assert.assertEquals((short)slice.getShort((int)index), (short)-21931);
        try {
            slice.getShort(-1);
            Assert.fail((String)"expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            slice.getShort(slice.length() - 2 + 1);
            Assert.fail((String)"expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            slice.getShort(slice.length());
            Assert.fail((String)"expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            slice.getShort(slice.length() + 1);
            Assert.fail((String)"expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testInt() {
        for (int size = 0; size < 100; ++size) {
            for (int index = 0; index < size - 4; ++index) {
                TestSlice.assertInt(this.allocate(size), index);
            }
        }
    }

    private static void assertInt(Slice slice, int index) {
        slice.fill((byte)-1);
        slice.setInt(index, -1431677611);
        Assert.assertEquals((int)slice.getInt(index), (int)-1431677611);
        try {
            slice.getInt(-1);
            Assert.fail((String)"expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            slice.getInt(slice.length() - 4 + 1);
            Assert.fail((String)"expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            slice.getInt(slice.length());
            Assert.fail((String)"expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            slice.getInt(slice.length() + 1);
            Assert.fail((String)"expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testLong() {
        for (int size = 0; size < 100; ++size) {
            for (int index = 0; index < size - 8; ++index) {
                TestSlice.assertLong(this.allocate(size), index);
            }
        }
    }

    private static void assertLong(Slice slice, int index) {
        slice.fill((byte)-1);
        slice.setLong(index, -6148914692668172971L);
        Assert.assertEquals((long)slice.getLong(index), (long)-6148914692668172971L);
        try {
            slice.getLong(-1);
            Assert.fail((String)"expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            slice.getLong(slice.length() - 8 + 1);
            Assert.fail((String)"expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            slice.getLong(slice.length());
            Assert.fail((String)"expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            slice.getLong(slice.length() + 1);
            Assert.fail((String)"expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testFloat() {
        for (int size = 0; size < 100; ++size) {
            for (int index = 0; index < size - 4; ++index) {
                TestSlice.assertFloat(this.allocate(size), index);
            }
        }
    }

    private static void assertFloat(Slice slice, int index) {
        slice.fill((byte)-1);
        slice.setFloat(index, Float.intBitsToFloat(-1431677611));
        Assert.assertEquals((int)Float.floatToIntBits(slice.getFloat(index)), (int)-1431677611);
        try {
            slice.getFloat(-1);
            Assert.fail((String)"expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            slice.getFloat(slice.length() - 4 + 1);
            Assert.fail((String)"expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            slice.getFloat(slice.length());
            Assert.fail((String)"expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            slice.getFloat(slice.length() + 1);
            Assert.fail((String)"expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testDouble() {
        for (int size = 0; size < 100; ++size) {
            for (int index = 0; index < size - 8; ++index) {
                TestSlice.assertDouble(this.allocate(size), index);
            }
        }
    }

    private static void assertDouble(Slice slice, int index) {
        slice.fill((byte)-1);
        slice.setDouble(index, Double.longBitsToDouble(-6148914692668172971L));
        Assert.assertEquals((long)Double.doubleToLongBits(slice.getDouble(index)), (long)-6148914692668172971L);
        try {
            slice.getDouble(-1);
            Assert.fail((String)"expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            slice.getDouble(slice.length() - 8 + 1);
            Assert.fail((String)"expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            slice.getDouble(slice.length());
            Assert.fail((String)"expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            slice.getDouble(slice.length() + 1);
            Assert.fail((String)"expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testBytesArray() {
        for (int size = 0; size < 100; ++size) {
            for (int index = 0; index < size; ++index) {
                TestSlice.assertBytesArray(this.allocate(size), index);
            }
        }
    }

    private static void assertBytesArray(Slice slice, int index) {
        slice.fill((byte)-1);
        byte[] value = new byte[slice.length()];
        Arrays.fill(value, (byte)-1);
        Assert.assertEquals((byte[])slice.getBytes(), (byte[])value);
        value = new byte[(slice.length() - index) / 2];
        for (int i = 0; i < value.length; ++i) {
            value[i] = (byte)i;
        }
        slice.setBytes(index, value);
        Assert.assertEquals((byte[])slice.getBytes(index, value.length), (byte[])value);
        for (int length = 0; length < value.length; ++length) {
            slice.fill((byte)-1);
            slice.setBytes(index, value, 0, length);
            Assert.assertEquals((byte[])slice.getBytes(index, length), (byte[])Arrays.copyOf(value, length));
        }
    }

    @Test
    public void testBytesSlice() {
        for (int size = 0; size < 100; ++size) {
            for (int index = 0; index < size; ++index) {
                this.assertBytesSlice(this.allocate(size), index);
            }
        }
    }

    private void assertBytesSlice(Slice slice, int index) {
        slice.fill((byte)-1);
        Assert.assertEquals((Object)slice.slice(0, slice.length()), (Object)slice);
        Slice value = this.allocate(slice.length());
        slice.getBytes(0, value, 0, slice.length());
        Assert.assertEquals((Object)value, (Object)slice);
        value = this.allocate((slice.length() - index) / 2);
        for (int i = 0; i < value.length(); ++i) {
            value.setByte(i, i);
        }
        slice.setBytes(index, value);
        Assert.assertEquals((Object)value, (Object)slice.slice(index, value.length()));
        Slice tempValue = this.allocate(value.length());
        slice.getBytes(index, tempValue, 0, tempValue.length());
        Assert.assertEquals((Object)tempValue, (Object)slice.slice(index, tempValue.length()));
        Assert.assertTrue((boolean)tempValue.equals(0, tempValue.length(), slice, index, tempValue.length()));
        for (int length = 0; length < value.length(); ++length) {
            slice.fill((byte)-1);
            slice.setBytes(index, value, 0, length);
            Assert.assertEquals((Object)value.slice(0, length), (Object)slice.slice(index, length));
            Assert.assertTrue((boolean)value.equals(0, length, slice, index, length));
            tempValue = this.allocate(length);
            slice.getBytes(index, tempValue);
            Assert.assertEquals((Object)tempValue, (Object)slice.slice(index, length));
            Assert.assertTrue((boolean)tempValue.equals(0, length, slice, index, length));
        }
    }

    @Test
    public void testBytesStreams() throws Exception {
        for (int size = 0; size < 100; ++size) {
            for (int index = 0; index < size; ++index) {
                TestSlice.assertBytesStreams(this.allocate(size), index);
            }
        }
        TestSlice.assertBytesStreams(this.allocate(16384), 3);
    }

    private static void assertBytesStreams(Slice slice, int index) throws Exception {
        slice.fill((byte)-1);
        byte[] value = new byte[slice.length()];
        Arrays.fill(value, (byte)-1);
        Assert.assertEquals((byte[])slice.getBytes(), (byte[])value);
        value = new byte[(slice.length() - index) / 2];
        for (int i = 0; i < value.length; ++i) {
            value[i] = (byte)i;
        }
        slice.setBytes(index, (InputStream)new ByteArrayInputStream(value), value.length);
        Assert.assertEquals((byte[])slice.getBytes(index, value.length), (byte[])value);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        slice.getBytes(index, (OutputStream)out, value.length);
        Assert.assertEquals((byte[])slice.getBytes(index, value.length), (byte[])out.toByteArray());
        for (int length = 0; length < value.length; ++length) {
            slice.fill((byte)-1);
            slice.setBytes(index, (InputStream)new ByteArrayInputStream(value), length);
            Assert.assertEquals((byte[])slice.getBytes(index, length), (byte[])Arrays.copyOf(value, length));
            out = new ByteArrayOutputStream();
            slice.getBytes(index, (OutputStream)out, length);
            Assert.assertEquals((byte[])slice.getBytes(index, length), (byte[])out.toByteArray());
        }
    }

    @Test
    public void testMemoryMappedReads() throws IOException {
        Path path = Files.createTempFile("longs", null, new FileAttribute[0]);
        List<Long> values = TestSlice.createRandomLongs(20000);
        Slice output = this.allocate(values.size() * 8);
        for (int i = 0; i < values.size(); ++i) {
            output.setLong(i * 8, values.get(i).longValue());
        }
        Files.write(path, output.getBytes(), new OpenOption[0]);
        Slice slice = Slices.mapFileReadOnly((File)path.toFile());
        for (int i = 0; i < values.size(); ++i) {
            long actual = slice.getLong(i * 8);
            long expected = values.get(i);
            Assert.assertEquals((long)actual, (long)expected);
        }
        Assert.assertEquals((byte[])slice.getBytes(), (byte[])output.getBytes());
    }

    @Test
    public void testRetainedSize() throws Exception {
        Slice slice = Slices.allocate((int)10);
        Assert.assertEquals((int)slice.getRetainedSize(), (int)10);
        Assert.assertEquals((int)slice.length(), (int)10);
        Slice subSlice = slice.slice(0, 1);
        Assert.assertEquals((int)subSlice.getRetainedSize(), (int)10);
        Assert.assertEquals((int)subSlice.length(), (int)1);
    }

    @Test
    public void testCopyOf() throws Exception {
        Assert.assertSame((Object)Slices.copyOf((Slice)Slices.EMPTY_SLICE), (Object)Slices.EMPTY_SLICE);
        Assert.assertSame((Object)Slices.copyOf((Slice)Slices.utf8Slice((String)"hello world"), (int)1, (int)0), (Object)Slices.EMPTY_SLICE);
        Slice slice = Slices.utf8Slice((String)"hello world");
        Assert.assertEquals((Object)Slices.copyOf((Slice)slice), (Object)slice);
        Assert.assertEquals((Object)Slices.copyOf((Slice)slice, (int)1, (int)3), (Object)slice.slice(1, 3));
        Slice original = Slices.utf8Slice((String)"hello world");
        Slice copy = Slices.copyOf((Slice)original);
        original.fill((byte)0);
        Assert.assertEquals((Object)copy, (Object)Slices.utf8Slice((String)"hello world"));
        try {
            Slices.copyOf((Slice)slice, (int)-1, (int)slice.length());
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            Slices.copyOf((Slice)slice, (int)(slice.length() + 1), (int)1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            Slices.copyOf((Slice)slice, (int)1, (int)slice.length());
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testIndexOf() throws Exception {
        TestSlice.assertIndexOf(Slices.utf8Slice((String)"no-match-bigger"), Slices.utf8Slice((String)"test"));
        TestSlice.assertIndexOf(Slices.utf8Slice((String)"no"), Slices.utf8Slice((String)"test"));
        TestSlice.assertIndexOf(Slices.utf8Slice((String)"test"), Slices.utf8Slice((String)"test"));
        TestSlice.assertIndexOf(Slices.utf8Slice((String)"test-start"), Slices.utf8Slice((String)"test"));
        TestSlice.assertIndexOf(Slices.utf8Slice((String)"end-test"), Slices.utf8Slice((String)"test"));
        TestSlice.assertIndexOf(Slices.utf8Slice((String)"a-test-middle"), Slices.utf8Slice((String)"test"));
        TestSlice.assertIndexOf(Slices.utf8Slice((String)"this-test-is-a-test"), Slices.utf8Slice((String)"test"));
        TestSlice.assertIndexOf(Slices.utf8Slice((String)"test"), Slices.EMPTY_SLICE, 0, 0);
        TestSlice.assertIndexOf(Slices.EMPTY_SLICE, Slices.utf8Slice((String)"test"), 0, -1);
        TestSlice.assertIndexOf(Slices.utf8Slice((String)"test"), Slices.utf8Slice((String)"no"), 4, -1);
        TestSlice.assertIndexOf(Slices.utf8Slice((String)"test"), Slices.utf8Slice((String)"no"), 5, -1);
        TestSlice.assertIndexOf(Slices.utf8Slice((String)"test"), Slices.utf8Slice((String)"no"), -1, -1);
    }

    public static void assertIndexOf(Slice data, Slice pattern, int offset, int expected) {
        Assert.assertEquals((int)data.indexOf(pattern, offset), (int)expected);
        Assert.assertEquals((int)data.indexOfBruteForce(pattern, offset), (int)expected);
    }

    public static void assertIndexOf(Slice data, Slice pattern) {
        ArrayList<Integer> bruteForce = new ArrayList<Integer>();
        int index = 0;
        while (index >= 0 && index < data.length()) {
            if ((index = data.indexOfBruteForce(pattern, index)) < 0) continue;
            bruteForce.add(index);
            ++index;
        }
        ArrayList<Integer> indexOf = new ArrayList<Integer>();
        index = 0;
        while (index >= 0 && index < data.length()) {
            if ((index = data.indexOf(pattern, index)) < 0) continue;
            indexOf.add(index);
            ++index;
        }
        Assert.assertEquals(bruteForce, indexOf);
    }

    private static List<Long> createRandomLongs(int count) {
        Random random = new Random();
        ArrayList<Long> list = new ArrayList<Long>(count);
        for (int i = 0; i < count; ++i) {
            list.add(random.nextLong());
        }
        return Collections.unmodifiableList(list);
    }

    protected Slice allocate(int size) {
        return Slices.allocate((int)size);
    }
}

