/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import com.google.common.hash.Hashing;
import io.airlift.slice.Murmur3Hash32;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.concurrent.ThreadLocalRandom;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMurmur3Hash32 {
    @Test(invocationCount=100)
    public void testLessThan4Bytes() throws Exception {
        byte[] data = TestMurmur3Hash32.randomBytes(ThreadLocalRandom.current().nextInt(4));
        int expected = Hashing.murmur3_32().hashBytes(data).asInt();
        int actual = Murmur3Hash32.hash((Slice)Slices.wrappedBuffer((byte[])data));
        Assert.assertEquals((int)actual, (int)expected);
    }

    @Test(invocationCount=100)
    public void testMoreThan4Bytes() throws Exception {
        byte[] data = TestMurmur3Hash32.randomBytes(131);
        int expected = Hashing.murmur3_32().hashBytes(data).asInt();
        int actual = Murmur3Hash32.hash((Slice)Slices.wrappedBuffer((byte[])data));
        Assert.assertEquals((int)actual, (int)expected);
    }

    @Test(invocationCount=100)
    public void testOffsetAndLength() throws Exception {
        byte[] data = TestMurmur3Hash32.randomBytes(131);
        int offset = 13;
        int length = 55;
        int expected = Hashing.murmur3_32().hashBytes(data, offset, length).asInt();
        int actual = Murmur3Hash32.hash((Slice)Slices.wrappedBuffer((byte[])data), (int)offset, (int)length);
        Assert.assertEquals((int)actual, (int)expected);
    }

    @Test(invocationCount=100)
    public void testNonDefaultSeed() throws Exception {
        byte[] data = TestMurmur3Hash32.randomBytes(131);
        int seed = 123456789;
        int expected = Hashing.murmur3_32((int)seed).hashBytes(data).asInt();
        int actual = Murmur3Hash32.hash((int)seed, (Slice)Slices.wrappedBuffer((byte[])data), (int)0, (int)data.length);
        Assert.assertEquals((int)actual, (int)expected);
    }

    @Test
    public void testTail() throws Exception {
        for (int i = 0; i < 4; ++i) {
            byte[] data = TestMurmur3Hash32.randomBytes(50 + i);
            int expected = Hashing.murmur3_32().hashBytes(data).asInt();
            int actual = Murmur3Hash32.hash((Slice)Slices.wrappedBuffer((byte[])data));
            Assert.assertEquals((int)actual, (int)expected);
        }
    }

    @Test(invocationCount=100)
    public void testSingleInt() throws Exception {
        int value = ThreadLocalRandom.current().nextInt();
        Slice slice = Slices.allocate((int)4);
        slice.setInt(0, value);
        int expected = Murmur3Hash32.hash((Slice)slice);
        int actual = Murmur3Hash32.hash((int)value);
        Assert.assertEquals((int)actual, (int)expected);
    }

    @Test(invocationCount=100)
    public void testSingleLong() throws Exception {
        long value = ThreadLocalRandom.current().nextLong();
        Slice slice = Slices.allocate((int)8);
        slice.setLong(0, value);
        int expected = Murmur3Hash32.hash((Slice)slice);
        int actual = Murmur3Hash32.hash((long)value);
        Assert.assertEquals((int)actual, (int)expected);
    }

    private static byte[] randomBytes(int length) {
        byte[] result = new byte[length];
        ThreadLocalRandom.current().nextBytes(result);
        return result;
    }
}

