/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import com.google.common.base.Preconditions;
import io.airlift.slice.AbstractSliceInputTest;
import io.airlift.slice.ChunkedSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.Slices;

public class TestChunkedSliceInput
extends AbstractSliceInputTest {
    @Override
    protected SliceInput createSliceInput(Slice slice) {
        return new ChunkedSliceInput((ChunkedSliceInput.SliceLoader)new SliceSliceLoader(slice), 129);
    }

    private static class SliceSliceLoader
    implements ChunkedSliceInput.SliceLoader<ChunkedSliceInput.BufferReference> {
        private final Slice data;

        public SliceSliceLoader(Slice data) {
            this.data = data;
        }

        public ChunkedSliceInput.BufferReference createBuffer(int bufferSize) {
            final Slice slice = Slices.allocate((int)bufferSize);
            return new ChunkedSliceInput.BufferReference(){

                public Slice getSlice() {
                    return slice;
                }
            };
        }

        public long getSize() {
            return this.data.length();
        }

        public void load(long position, ChunkedSliceInput.BufferReference buffer, int length) {
            Preconditions.checkPositionIndex((int)((int)(position + (long)length)), (int)((int)this.getSize()));
            this.data.getBytes((int)position, buffer.getSlice(), 0, length);
        }

        public void close() {
        }
    }
}

