/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import io.airlift.slice.JvmUtils;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.concurrent.ThreadLocalRandom;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@BenchmarkMode(value={Mode.Throughput})
@Fork(value=5)
@Warmup(iterations=10)
@Measurement(iterations=10)
public class MemoryCopyBenchmark {
    static final int PAGE_SIZE = 4096;
    static final int N_PAGES = 262144;
    static final int ALLOC_SIZE = 0x40000000;

    @Benchmark
    public Slice b00sliceZero(Buffers buffers) {
        return MemoryCopyBenchmark.doCopy(buffers, CopyStrategy.SLICE, 0);
    }

    @Benchmark
    public Slice b01customLoopZero(Buffers buffers) {
        return MemoryCopyBenchmark.doCopy(buffers, CopyStrategy.CUSTOM_LOOP, 0);
    }

    @Benchmark
    public Slice b02unsafeZero(Buffers buffers) {
        return MemoryCopyBenchmark.doCopy(buffers, CopyStrategy.UNSAFE, 0);
    }

    @Benchmark
    public Slice b03slice32B(Buffers buffers) {
        return MemoryCopyBenchmark.doCopy(buffers, CopyStrategy.SLICE, 32);
    }

    @Benchmark
    public Slice b04customLoop32B(Buffers buffers) {
        return MemoryCopyBenchmark.doCopy(buffers, CopyStrategy.CUSTOM_LOOP, 32);
    }

    @Benchmark
    public Slice b05unsafe32B(Buffers buffers) {
        return MemoryCopyBenchmark.doCopy(buffers, CopyStrategy.UNSAFE, 32);
    }

    @Benchmark
    public Slice b06slice128B(Buffers buffers) {
        return MemoryCopyBenchmark.doCopy(buffers, CopyStrategy.SLICE, 128);
    }

    @Benchmark
    public Slice b07customLoop128B(Buffers buffers) {
        return MemoryCopyBenchmark.doCopy(buffers, CopyStrategy.CUSTOM_LOOP, 128);
    }

    @Benchmark
    public Slice b08unsafe128B(Buffers buffers) {
        return MemoryCopyBenchmark.doCopy(buffers, CopyStrategy.UNSAFE, 128);
    }

    @Benchmark
    public Slice b09slice512B(Buffers buffers) {
        return MemoryCopyBenchmark.doCopy(buffers, CopyStrategy.SLICE, 512);
    }

    @Benchmark
    public Slice b10customLoop512B(Buffers buffers) {
        return MemoryCopyBenchmark.doCopy(buffers, CopyStrategy.CUSTOM_LOOP, 512);
    }

    @Benchmark
    public Slice b11unsafe512B(Buffers buffers) {
        return MemoryCopyBenchmark.doCopy(buffers, CopyStrategy.UNSAFE, 512);
    }

    @Benchmark
    public Slice b12slice1K(Buffers buffers) {
        return MemoryCopyBenchmark.doCopy(buffers, CopyStrategy.SLICE, 1024);
    }

    @Benchmark
    public Slice b13customLoop1K(Buffers buffers) {
        return MemoryCopyBenchmark.doCopy(buffers, CopyStrategy.CUSTOM_LOOP, 1024);
    }

    @Benchmark
    public Slice b14unsafe1K(Buffers buffers) {
        return MemoryCopyBenchmark.doCopy(buffers, CopyStrategy.UNSAFE, 1024);
    }

    @Benchmark
    public Slice b15slice1M(Buffers buffers) {
        return MemoryCopyBenchmark.doCopy(buffers, CopyStrategy.SLICE, 0x100000);
    }

    @Benchmark
    public Slice b16customLoop1M(Buffers buffers) {
        return MemoryCopyBenchmark.doCopy(buffers, CopyStrategy.CUSTOM_LOOP, 0x100000);
    }

    @Benchmark
    public Slice b17unsafe1M(Buffers buffers) {
        return MemoryCopyBenchmark.doCopy(buffers, CopyStrategy.UNSAFE, 0x100000);
    }

    @Benchmark
    public Slice b18slice128M(Buffers buffers) {
        return MemoryCopyBenchmark.doCopy(buffers, CopyStrategy.SLICE, 0x8000000);
    }

    @Benchmark
    public Slice b19customLoop128M(Buffers buffers) {
        return MemoryCopyBenchmark.doCopy(buffers, CopyStrategy.CUSTOM_LOOP, 0x8000000);
    }

    @Benchmark
    public Slice b20unsafe128M(Buffers buffers) {
        return MemoryCopyBenchmark.doCopy(buffers, CopyStrategy.UNSAFE, 0x8000000);
    }

    static Slice doCopy(Buffers buffers, CopyStrategy strategy, int length) {
        assert (buffers.startOffset >= 0L) : "startOffset < 0";
        assert (buffers.destOffset >= 0L) : "destOffset < 0";
        assert (buffers.startOffset + (long)length < 0x40000000L) : "startOffset + length >= ALLOC_SIZE";
        assert (buffers.destOffset + (long)length < 0x40000000L) : "destOffset + length >= ALLOC_SIZE";
        strategy.doCopy(buffers.data, buffers.startOffset, buffers.destOffset, length);
        return buffers.data;
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + MemoryCopyBenchmark.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    private static enum CopyStrategy {
        SLICE{

            @Override
            public void doCopy(Slice data, long src, long dest, int length) {
                data.setBytes((int)dest, data, (int)src, length);
            }
        }
        ,
        CUSTOM_LOOP{

            @Override
            public void doCopy(Slice data, long src, long dest, int length) {
                Object base = data.getBase();
                long offset = data.getAddress();
                while (length >= 8) {
                    long srcLong = JvmUtils.unsafe.getLong(base, src + offset);
                    JvmUtils.unsafe.putLong(base, dest + offset, srcLong);
                    offset += 8L;
                    length -= 8;
                }
                while (length > 0) {
                    byte srcByte = JvmUtils.unsafe.getByte(base, src + offset);
                    JvmUtils.unsafe.putByte(base, dest + offset, srcByte);
                    ++offset;
                    --length;
                }
            }
        }
        ,
        UNSAFE{

            @Override
            public void doCopy(Slice data, long srcOffset, long destOffset, int length) {
                Object base = data.getBase();
                int bytesToCopy = length - length % 8;
                JvmUtils.unsafe.copyMemory(base, srcOffset += data.getAddress(), base, destOffset += data.getAddress(), bytesToCopy);
                JvmUtils.unsafe.copyMemory(base, srcOffset + (long)bytesToCopy, base, destOffset + (long)bytesToCopy, length - bytesToCopy);
            }
        };


        public abstract void doCopy(Slice var1, long var2, long var4, int var6);
    }

    @State(value=Scope.Thread)
    public static class Buffers {
        Slice data;
        long startOffset;
        long destOffset;

        @Setup
        public void fillWithBogusData() {
            this.data = Slices.allocate((int)0x40000000);
            for (int idx = 0; idx < this.data.length() / 8; ++idx) {
                this.data.setLong(idx, ThreadLocalRandom.current().nextLong());
            }
            long startOffsetPages = ThreadLocalRandom.current().nextInt(65536);
            long destOffsetPages = ThreadLocalRandom.current().nextInt(65536) + 131072;
            this.startOffset = startOffsetPages * 4096L;
            this.destOffset = destOffsetPages * 4096L;
        }
    }
}

