/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import com.google.common.hash.Hashing;
import io.airlift.slice.BenchmarkData;
import io.airlift.slice.ByteCounter;
import io.airlift.slice.Murmur3Hash32;
import io.airlift.slice.SingleLong;
import io.airlift.slice.Slice;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=5)
@Warmup(iterations=5, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkMurmur3Hash32 {
    @Benchmark
    public int hash(BenchmarkData data, ByteCounter counter) {
        counter.add(data.getSlice().length());
        return Murmur3Hash32.hash((Slice)data.getSlice());
    }

    @Benchmark
    public int guava(BenchmarkData data, ByteCounter counter) {
        counter.add(data.getSlice().length());
        return Hashing.murmur3_32().hashBytes(data.getBytes()).asInt();
    }

    @Benchmark
    public int specializedHashInt(SingleLong data, ByteCounter counter) {
        counter.add(4L);
        return Murmur3Hash32.hash((int)((int)data.getValue()));
    }

    @Benchmark
    public int hashInt(BenchmarkData data, ByteCounter counter) {
        counter.add(4L);
        return Murmur3Hash32.hash((Slice)data.getSlice(), (int)0, (int)4);
    }

    @Benchmark
    public int specializedHashLong(SingleLong data, ByteCounter counter) {
        counter.add(8L);
        return Murmur3Hash32.hash((long)data.getValue());
    }

    @Benchmark
    public int hashLong(BenchmarkData data, ByteCounter counter) {
        counter.add(8L);
        return Murmur3Hash32.hash((Slice)data.getSlice(), (int)0, (int)8);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkMurmur3Hash32.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }
}

