/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AbstractSliceInputTest {
    protected static final int BUFFER_SIZE = 129;
    private static final List<Integer> VARIABLE_READ_SIZES = ImmutableList.of((Object)1, (Object)7, (Object)15, (Object)128, (Object)129, (Object)130, (Object)142);

    protected abstract SliceInput createSliceInput(Slice var1);

    @Test
    public void testReadBoolean() {
        this.testSliceInput(new SliceInputTester(1){

            @Override
            public void loadValue(SliceOutput output, int valueIndex) {
                output.writeBoolean(valueIndex % 2 == 0);
            }

            @Override
            public void verifyValue(SliceInput input, int valueIndex) {
                Assert.assertEquals((boolean)input.readBoolean(), (valueIndex % 2 == 0 ? 1 : 0) != 0);
            }
        });
    }

    @Test
    public void testReadByte() {
        this.testSliceInput(new SliceInputTester(1){

            @Override
            public void loadValue(SliceOutput output, int valueIndex) {
                output.appendByte((int)((byte)valueIndex));
            }

            @Override
            public void verifyValue(SliceInput input, int valueIndex) {
                Assert.assertEquals((byte)input.readByte(), (byte)((byte)valueIndex));
            }
        });
    }

    @Test
    public void testRead() {
        this.testSliceInput(new SliceInputTester(1){

            @Override
            public void loadValue(SliceOutput output, int valueIndex) {
                output.appendByte((int)((byte)valueIndex));
            }

            @Override
            public void verifyValue(SliceInput input, int valueIndex) {
                Assert.assertEquals((int)input.read(), (int)(valueIndex & 0xFF));
            }

            @Override
            public void verifyReadOffEnd(SliceInput input) {
                Assert.assertEquals((int)input.read(), (int)-1);
            }
        });
    }

    @Test
    public void testReadShort() {
        this.testSliceInput(new SliceInputTester(2){

            @Override
            public void loadValue(SliceOutput output, int valueIndex) {
                output.appendShort(valueIndex);
            }

            @Override
            public void verifyValue(SliceInput input, int valueIndex) {
                Assert.assertEquals((short)input.readShort(), (short)((short)valueIndex));
            }
        });
    }

    @Test
    public void testReadUnsignedShort() {
        this.testSliceInput(new SliceInputTester(2){

            @Override
            public void loadValue(SliceOutput output, int valueIndex) {
                output.appendShort(valueIndex);
            }

            @Override
            public void verifyValue(SliceInput input, int valueIndex) {
                Assert.assertEquals((int)input.readUnsignedShort(), (int)(valueIndex & 0xFFF));
            }
        });
    }

    @Test
    public void testReadInt() {
        this.testSliceInput(new SliceInputTester(4){

            @Override
            public void loadValue(SliceOutput output, int valueIndex) {
                output.appendInt(valueIndex);
            }

            @Override
            public void verifyValue(SliceInput input, int valueIndex) {
                Assert.assertEquals((int)input.readInt(), (int)valueIndex);
            }
        });
    }

    @Test
    public void testUnsignedReadInt() {
        this.testSliceInput(new SliceInputTester(4){

            @Override
            public void loadValue(SliceOutput output, int valueIndex) {
                output.appendInt(valueIndex);
            }

            @Override
            public void verifyValue(SliceInput input, int valueIndex) {
                Assert.assertEquals((long)input.readUnsignedInt(), (long)valueIndex);
            }
        });
    }

    @Test
    public void testReadLong() {
        this.testSliceInput(new SliceInputTester(8){

            @Override
            public void loadValue(SliceOutput output, int valueIndex) {
                output.appendLong((long)valueIndex);
            }

            @Override
            public void verifyValue(SliceInput input, int valueIndex) {
                Assert.assertEquals((long)input.readLong(), (long)valueIndex);
            }
        });
    }

    @Test
    public void testReadFloat() {
        this.testSliceInput(new SliceInputTester(4){

            @Override
            public void loadValue(SliceOutput output, int valueIndex) {
                output.writeFloat((float)valueIndex + 0.12f);
            }

            @Override
            public void verifyValue(SliceInput input, int valueIndex) {
                Assert.assertEquals((Object)Float.valueOf(input.readFloat()), (Object)Float.valueOf((float)valueIndex + 0.12f));
            }
        });
    }

    @Test
    public void testReadDouble() {
        this.testSliceInput(new SliceInputTester(8){

            @Override
            public void loadValue(SliceOutput output, int valueIndex) {
                output.appendDouble((double)valueIndex + 0.12);
            }

            @Override
            public void verifyValue(SliceInput input, int valueIndex) {
                Assert.assertEquals((Object)input.readDouble(), (Object)((double)valueIndex + 0.12));
            }
        });
    }

    @Test
    public void testSkip() {
        for (int readSize : VARIABLE_READ_SIZES) {
            this.testSliceInput(new SkipSliceInputTester(readSize){

                @Override
                public void verifyValue(SliceInput input, int valueIndex) {
                    input.skip((long)this.valueSize());
                }

                @Override
                public void verifyReadOffEnd(SliceInput input) {
                    Assert.assertEquals((long)input.skip((long)this.valueSize()), (long)(this.valueSize() - 1));
                }
            });
            this.testSliceInput(new SkipSliceInputTester(readSize){

                @Override
                public void verifyValue(SliceInput input, int valueIndex) {
                    input.skipBytes(this.valueSize());
                }

                @Override
                public void verifyReadOffEnd(SliceInput input) {
                    Assert.assertEquals((long)input.skip((long)this.valueSize()), (long)(this.valueSize() - 1));
                }
            });
            this.testSliceInput(new SkipSliceInputTester(readSize){

                @Override
                public void verifyValue(SliceInput input, int valueIndex) {
                    int skipSize;
                    for (int length = this.valueSize(); length > 0; length -= skipSize) {
                        if (!input.isReadable()) {
                            input.readByte();
                            --length;
                        }
                        skipSize = input.skipBytes(length);
                    }
                    Assert.assertEquals((long)input.skip(0L), (long)0L);
                }
            });
            this.testSliceInput(new SkipSliceInputTester(readSize){

                @Override
                public void verifyValue(SliceInput input, int valueIndex) {
                    long skipSize;
                    for (long length = (long)this.valueSize(); length > 0L; length -= skipSize) {
                        if (!input.isReadable()) {
                            input.readByte();
                            --length;
                        }
                        skipSize = input.skip(length);
                    }
                    Assert.assertEquals((long)input.skip(0L), (long)0L);
                }
            });
        }
    }

    @Test
    public void testReadSlice() {
        for (int readSize : VARIABLE_READ_SIZES) {
            this.testSliceInput(new StringSliceInputTester(readSize){

                @Override
                public String readActual(SliceInput input) {
                    return input.readSlice(this.valueSize()).toStringUtf8();
                }
            });
        }
    }

    @Test
    public void testReadBytes() {
        for (int readSize : VARIABLE_READ_SIZES) {
            this.testSliceInput(new StringSliceInputTester(readSize){

                @Override
                public String readActual(SliceInput input) {
                    Slice slice = Slices.allocate((int)this.valueSize());
                    input.readBytes(slice);
                    return slice.toStringUtf8();
                }
            });
            this.testSliceInput(new StringSliceInputTester(readSize){

                @Override
                public String readActual(SliceInput input) {
                    Slice slice = Slices.allocate((int)(this.valueSize() + 5));
                    input.readBytes(slice, this.valueSize());
                    return slice.slice(0, this.valueSize()).toStringUtf8();
                }
            });
            this.testSliceInput(new StringSliceInputTester(readSize){

                @Override
                public String readActual(SliceInput input) {
                    Slice slice = Slices.allocate((int)(this.valueSize() + 10));
                    input.readBytes(slice, 5, this.valueSize());
                    return slice.slice(5, this.valueSize()).toStringUtf8();
                }
            });
            this.testSliceInput(new StringSliceInputTester(readSize){

                @Override
                public String readActual(SliceInput input) {
                    byte[] bytes = new byte[this.valueSize()];
                    input.readBytes(bytes, 0, this.valueSize());
                    return new String(bytes, 0, this.valueSize(), StandardCharsets.UTF_8);
                }
            });
            this.testSliceInput(new StringSliceInputTester(readSize){

                @Override
                public String readActual(SliceInput input) {
                    byte[] bytes = new byte[this.valueSize() + 10];
                    input.readBytes(bytes, 5, this.valueSize());
                    return new String(bytes, 5, this.valueSize(), StandardCharsets.UTF_8);
                }
            });
            this.testSliceInput(new StringSliceInputTester(readSize){

                @Override
                public String readActual(SliceInput input) {
                    byte[] bytes = new byte[this.valueSize()];
                    int bytesRead = input.read(bytes);
                    if (bytesRead == -1) {
                        throw new IndexOutOfBoundsException();
                    }
                    Assert.assertTrue((bytesRead > 0 ? 1 : 0) != 0, (String)"Expected to read at least one byte");
                    input.readBytes(bytes, bytesRead, bytes.length - bytesRead);
                    return new String(bytes, 0, this.valueSize(), StandardCharsets.UTF_8);
                }
            });
            this.testSliceInput(new StringSliceInputTester(readSize){

                @Override
                public String readActual(SliceInput input) {
                    try {
                        byte[] bytes = new byte[this.valueSize() + 10];
                        ByteStreams.readFully((InputStream)input, (byte[])bytes, (int)5, (int)this.valueSize());
                        return new String(bytes, 5, this.valueSize(), StandardCharsets.UTF_8);
                    }
                    catch (EOFException e) {
                        throw new IndexOutOfBoundsException();
                    }
                    catch (IOException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            });
            this.testSliceInput(new StringSliceInputTester(readSize){

                @Override
                public String readActual(SliceInput input) {
                    try {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        input.readBytes((OutputStream)out, this.valueSize());
                        return new String(out.toByteArray(), StandardCharsets.UTF_8);
                    }
                    catch (IOException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            });
        }
    }

    protected void testSliceInput(SliceInputTester tester) {
        Slice slice = Slices.allocate((int)397);
        SliceOutput output = slice.getOutput();
        for (int i = 0; i < slice.length() / tester.valueSize(); ++i) {
            tester.loadValue(output, i);
        }
        this.testReadForward(tester, slice);
        this.testReadReverse(tester, slice);
        this.testReadOffEnd(tester, slice);
    }

    protected void testReadReverse(SliceInputTester tester, Slice slice) {
        SliceInput input = this.createSliceInput(slice);
        for (int i = slice.length() / tester.valueSize() - 1; i >= 0; --i) {
            int position = i * tester.valueSize();
            input.setPosition((long)position);
            Assert.assertEquals((long)input.position(), (long)position);
            tester.verifyValue(input, i);
        }
    }

    protected void testReadForward(SliceInputTester tester, Slice slice) {
        SliceInput input = this.createSliceInput(slice);
        for (int i = 0; i < slice.length() / tester.valueSize(); ++i) {
            int position = i * tester.valueSize();
            Assert.assertEquals((long)input.position(), (long)position);
            tester.verifyValue(input, i);
        }
    }

    protected void testReadOffEnd(SliceInputTester tester, Slice slice) {
        SliceInput input = this.createSliceInput(slice);
        try {
            ByteStreams.skipFully((InputStream)input, (long)(slice.length() - tester.valueSize() + 1));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        tester.verifyReadOffEnd(input);
    }

    private static String getExpectedStringValue(int index, int size) {
        try {
            return ByteSource.concat((Iterable)Iterables.cycle((Object[])new ByteSource[]{ByteSource.wrap((byte[])String.valueOf(index).getBytes(StandardCharsets.UTF_8))})).slice(0L, (long)size).asCharSource(StandardCharsets.UTF_8).read();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static abstract class StringSliceInputTester
    extends SliceInputTester {
        public StringSliceInputTester(int size) {
            super(size);
        }

        @Override
        public final void loadValue(SliceOutput output, int valueIndex) {
            output.writeBytes(AbstractSliceInputTest.getExpectedStringValue(valueIndex, this.valueSize()).getBytes(StandardCharsets.UTF_8));
        }

        @Override
        public final void verifyValue(SliceInput input, int valueIndex) {
            String actual = this.readActual(input);
            String expected = AbstractSliceInputTest.getExpectedStringValue(valueIndex, this.valueSize());
            Assert.assertEquals((String)actual, (String)expected);
        }

        protected abstract String readActual(SliceInput var1);
    }

    private static abstract class SkipSliceInputTester
    extends SliceInputTester {
        public SkipSliceInputTester(int size) {
            super(size);
        }

        @Override
        public void loadValue(SliceOutput output, int valueIndex) {
            output.writeBytes(new byte[this.valueSize()]);
        }
    }

    protected static abstract class SliceInputTester {
        private final int size;

        public SliceInputTester(int size) {
            this.size = size;
        }

        public final int valueSize() {
            return this.size;
        }

        public abstract void loadValue(SliceOutput var1, int var2);

        public abstract void verifyValue(SliceInput var1, int var2);

        public void verifyReadOffEnd(SliceInput input) {
            try {
                this.verifyValue(input, 1);
                Assert.fail((String)"expected IndexOutOfBoundsException");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }
}

