/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.security.csr;

import com.google.common.io.BaseEncoding;
import io.airlift.security.csr.CertificationRequest;
import io.airlift.security.csr.CertificationRequestInfo;
import io.airlift.security.csr.SignatureAlgorithmIdentifier;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.ECGenParameterSpec;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCertificationRequest {
    @Test
    public void test() throws Exception {
        String name = "C=country";
        KeyPairGenerator generator = KeyPairGenerator.getInstance("EC");
        generator.initialize(new ECGenParameterSpec("secp256r1"));
        KeyPair keyPair = generator.generateKeyPair();
        CertificationRequestInfo certificationRequestInfo = new CertificationRequestInfo(new X500Principal(name), keyPair.getPublic());
        SignatureAlgorithmIdentifier signatureAlgorithmIdentifier = SignatureAlgorithmIdentifier.findSignatureAlgorithmIdentifier((String)"SHA256withECDSA");
        byte[] signature = certificationRequestInfo.sign(signatureAlgorithmIdentifier, keyPair.getPrivate());
        CertificationRequest certificationRequest = new CertificationRequest(certificationRequestInfo, signatureAlgorithmIdentifier, signature);
        Assert.assertEquals((Object)certificationRequest.getCertificationRequestInfo(), (Object)certificationRequestInfo);
        Assert.assertEquals((Object)certificationRequest.getSignatureAlgorithmIdentifier(), (Object)signatureAlgorithmIdentifier);
        Assert.assertEquals((String)BaseEncoding.base16().encode(certificationRequest.getSignature()), (String)BaseEncoding.base16().encode(signature));
        Assert.assertEquals((Object)certificationRequest, (Object)certificationRequest);
        Assert.assertEquals((int)certificationRequest.hashCode(), (int)certificationRequest.hashCode());
        PKCS10CertificationRequest expectedCertificationRequest = new PKCS10CertificationRequest(new org.bouncycastle.asn1.pkcs.CertificationRequest(new org.bouncycastle.asn1.pkcs.CertificationRequestInfo(new X500Name(name), SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded()), (ASN1Set)new DERSet()), new DefaultSignatureAlgorithmIdentifierFinder().find("SHA256withECDSA"), new DERBitString(signature)));
        Assert.assertEquals((String)BaseEncoding.base16().encode(certificationRequest.getEncoded()), (String)BaseEncoding.base16().encode(expectedCertificationRequest.getEncoded()));
    }
}

