/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.security.cert;

import io.airlift.security.cert.CertificateBuilder;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCertificateBuilder {
    @Test
    public void test() throws Exception {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        generator.initialize(2048);
        KeyPair keyPair = generator.generateKeyPair();
        X500Principal issuer = new X500Principal("CN=issuer,O=Airlift");
        X500Principal subject = new X500Principal("CN=subject,O=Airlift");
        LocalDate notBefore = LocalDate.now();
        LocalDate notAfter = notBefore.plus(10L, ChronoUnit.YEARS);
        X509Certificate certificate = CertificateBuilder.certificateBuilder().setKeyPair(keyPair).setSerialNumber(12345L).setIssuer(issuer).setNotBefore(notBefore).setNotAfter(notAfter).setSubject(subject).buildSelfSigned();
        Assert.assertEquals((Object)certificate.getSerialNumber(), (Object)BigInteger.valueOf(12345L));
        Assert.assertEquals((Object)certificate.getIssuerX500Principal(), (Object)issuer);
        Assert.assertEquals((Object)certificate.getNotBefore().toInstant(), (Object)notBefore.atStartOfDay().toInstant(ZoneOffset.UTC));
        Assert.assertEquals((Object)certificate.getNotAfter().toInstant(), (Object)notAfter.atTime(23, 59, 59).toInstant(ZoneOffset.UTC));
        Assert.assertEquals((Object)certificate.getSubjectX500Principal(), (Object)subject);
        Assert.assertEquals((Object)certificate.getPublicKey(), (Object)keyPair.getPublic());
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, new char[0]);
        keyStore.setCertificateEntry("test", certificate);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            X509TrustManager x509TrustManager = (X509TrustManager)trustManager;
            x509TrustManager.checkServerTrusted(new X509Certificate[]{certificate}, "RSA");
        }
    }
}

