/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.security.csr;

import com.google.common.io.BaseEncoding;
import io.airlift.security.csr.SignatureAlgorithmIdentifier;
import java.util.Map;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSignatureAlgorithmIdentifier {
    @Test
    public void test() throws Exception {
        for (Map.Entry entry : SignatureAlgorithmIdentifier.getAllSignatureAlgorithmIdentifiers().entrySet()) {
            SignatureAlgorithmIdentifier signatureAlgorithmIdentifier = (SignatureAlgorithmIdentifier)entry.getValue();
            Assert.assertEquals((String)signatureAlgorithmIdentifier.getName(), (String)((String)entry.getKey()));
            AlgorithmIdentifier algorithmIdentifier = new DefaultSignatureAlgorithmIdentifierFinder().find((String)entry.getKey());
            Assert.assertEquals((String)signatureAlgorithmIdentifier.getOid(), (String)algorithmIdentifier.getAlgorithm().getId());
            Assert.assertEquals((String)BaseEncoding.base16().encode(signatureAlgorithmIdentifier.getEncoded()), (String)BaseEncoding.base16().encode(algorithmIdentifier.getAlgorithm().getEncoded("DER")));
            Assert.assertEquals((Object)algorithmIdentifier, (Object)algorithmIdentifier);
            Assert.assertEquals((int)algorithmIdentifier.hashCode(), (int)algorithmIdentifier.hashCode());
        }
    }
}

