/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.security.csr;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.Objects;

final class DerEncoder {
    private static final int SEQUENCE_TAG = 48;
    private static final int BIT_STRING_TAG = 3;

    private DerEncoder() {
    }

    public static byte[] encodeSequence(byte[] ... encodedValues) {
        int length = 0;
        for (byte[] encodedValue : encodedValues) {
            length += encodedValue.length;
        }
        byte[] lengthEncoded = DerEncoder.encodeLength(length);
        ByteArrayDataOutput out = ByteStreams.newDataOutput((int)(1 + lengthEncoded.length + length));
        out.write(48);
        out.write(lengthEncoded);
        for (byte[] entry : encodedValues) {
            out.write(entry);
        }
        return out.toByteArray();
    }

    public static byte[] encodeBitString(int padBits, byte[] value) {
        Preconditions.checkArgument((padBits >= 0 && padBits < 8 ? 1 : 0) != 0, (Object)"Invalid pad bits");
        Objects.requireNonNull(Integer.valueOf(padBits), "padBits is null");
        byte[] lengthEncoded = DerEncoder.encodeLength(value.length + 1);
        ByteArrayDataOutput out = ByteStreams.newDataOutput((int)(2 + lengthEncoded.length + value.length));
        out.write(3);
        out.write(lengthEncoded);
        out.write(padBits);
        out.write(value);
        return out.toByteArray();
    }

    public static byte[] encodeLength(int length) {
        if (length < 128) {
            return new byte[]{(byte)length};
        }
        int numberOfBits = 32 - Integer.numberOfLeadingZeros(length);
        int numberOfBytes = (numberOfBits + 7) / 8;
        byte[] encoded = new byte[1 + numberOfBytes];
        encoded[0] = (byte)(numberOfBytes | 0x80);
        for (int i = 0; i < numberOfBytes; ++i) {
            int byteToEncode = numberOfBytes - i;
            int shiftSize = (byteToEncode - 1) * 8;
            encoded[i + 1] = (byte)(length >>> shiftSize);
        }
        return encoded;
    }
}

