/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.security.csr;

import com.google.common.base.MoreObjects;
import io.airlift.security.csr.DerEncoder;
import io.airlift.security.csr.SignatureAlgorithmIdentifier;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;

public class CertificationRequestInfo {
    private static final byte[] VERSION_0_ENCODED = new byte[]{2, 1, 0};
    private static final byte[] EMPTY_ATTRIBUTES_ENCODED = new byte[]{-96, 0};
    private final X500Principal subject;
    private final PublicKey publicKey;
    private final byte[] encoded;

    public CertificationRequestInfo(X500Principal subject, PublicKey publicKey) {
        this.subject = Objects.requireNonNull(subject, "subject is null");
        this.publicKey = Objects.requireNonNull(publicKey, "publicKey is null");
        this.encoded = DerEncoder.encodeSequence(VERSION_0_ENCODED, subject.getEncoded(), publicKey.getEncoded(), EMPTY_ATTRIBUTES_ENCODED);
    }

    public X500Principal getSubject() {
        return this.subject;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] getEncoded() {
        return (byte[])this.encoded.clone();
    }

    public byte[] sign(SignatureAlgorithmIdentifier signatureAlgorithmIdentifier, PrivateKey privateKey) throws GeneralSecurityException {
        Signature signature = Signature.getInstance(signatureAlgorithmIdentifier.getName());
        signature.initSign(privateKey);
        signature.update(this.getEncoded());
        return signature.sign();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertificationRequestInfo that = (CertificationRequestInfo)o;
        return Objects.equals(this.subject, that.subject) && Objects.equals(this.publicKey, that.publicKey);
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.publicKey);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("subject", (Object)this.subject).add("publicKey", (Object)this.publicKey).toString();
    }
}

