/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.security.pem;

import com.google.common.collect.Iterables;
import io.airlift.security.pem.PemReader;
import io.airlift.security.pem.PemWriter;
import java.io.File;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPemReader {
    @Test
    public void testLoadKeyStore() throws Exception {
        TestPemReader.testLoadKeyStore("rsa.crt", "rsa.key");
        TestPemReader.testLoadKeyStore("ec.crt", "ec.key");
        TestPemReader.testLoadKeyStore("dsa.crt", "dsa.key");
    }

    private static void testLoadKeyStore(String certFile, String keyFile) throws Exception {
        KeyStore keyStore = PemReader.loadKeyStore((File)TestPemReader.getResourceFile(certFile), (File)TestPemReader.getResourceFile(keyFile), Optional.empty());
        TestPemReader.assertCertificateChain(keyStore);
        Assert.assertNotNull((Object)keyStore.getCertificate("key"));
        Key key = keyStore.getKey("key", new char[0]);
        Assert.assertNotNull((Object)key);
        Assert.assertTrue((boolean)(key instanceof PrivateKey));
        PrivateKey privateKey = (PrivateKey)key;
        String encodedPrivateKey = PemWriter.writePrivateKey((PrivateKey)privateKey);
        Assert.assertEquals((Object)key, (Object)PemReader.loadPrivateKey((String)encodedPrivateKey, Optional.empty()));
    }

    @Test
    public void testLoadTrustStore() throws Exception {
        TestPemReader.assertCertificateChain(PemReader.loadTrustStore((File)TestPemReader.getResourceFile("rsa.crt")));
        TestPemReader.assertCertificateChain(PemReader.loadTrustStore((File)TestPemReader.getResourceFile("ec.crt")));
        TestPemReader.assertCertificateChain(PemReader.loadTrustStore((File)TestPemReader.getResourceFile("dsa.crt")));
    }

    @Test
    public void testLoadPublicKey() throws Exception {
        TestPemReader.testLoadPublicKey("rsa.crt", "rsa.pub");
        TestPemReader.testLoadPublicKey("ec.crt", "ec.pub");
        TestPemReader.testLoadPublicKey("dsa.crt", "dsa.pub");
    }

    private static void testLoadPublicKey(String certFile, String keyFile) throws Exception {
        PublicKey publicKey = PemReader.loadPublicKey((File)TestPemReader.getResourceFile(keyFile));
        Assert.assertNotNull((Object)publicKey);
        X509Certificate certificate = (X509Certificate)Iterables.getOnlyElement((Iterable)PemReader.readCertificateChain((File)TestPemReader.getResourceFile(certFile)));
        Assert.assertEquals((Object)publicKey, (Object)certificate.getPublicKey());
        String encodedPrivateKey = PemWriter.writePublicKey((PublicKey)publicKey);
        Assert.assertEquals((Object)publicKey, (Object)PemReader.loadPublicKey((String)encodedPrivateKey));
    }

    private static void assertCertificateChain(KeyStore keyStore) throws Exception {
        ArrayList<String> aliases = Collections.list(keyStore.aliases());
        Assert.assertEquals((int)aliases.size(), (int)1);
        Certificate certificate = keyStore.getCertificate(aliases.get(0));
        Assert.assertNotNull((Object)certificate);
        Assert.assertTrue((boolean)(certificate instanceof X509Certificate));
        X509Certificate x509Certificate = (X509Certificate)certificate;
        TestPemReader.assertX509Certificate(x509Certificate);
        X509Certificate certificateCopy = (X509Certificate)Iterables.getOnlyElement((Iterable)PemReader.readCertificateChain((String)PemWriter.writeCertificate((X509Certificate)x509Certificate)));
        TestPemReader.assertX509Certificate(certificateCopy);
    }

    private static void assertX509Certificate(X509Certificate x509Certificate) throws InvalidNameException {
        LdapName ldapName = new LdapName(x509Certificate.getSubjectX500Principal().getName());
        String cn = ldapName.getRdns().stream().filter(rdn -> rdn.getType().equals("CN")).map(Rdn::getValue).findFirst().map(String.class::cast).orElseThrow(() -> new AssertionError((Object)"Certificate subject name does not contain a CN"));
        Assert.assertEquals((String)cn, (String)"Test User");
    }

    private static File getResourceFile(String name) {
        URL resource = TestPemReader.class.getClassLoader().getResource(name);
        if (resource == null) {
            throw new IllegalArgumentException("Resource not found " + name);
        }
        return new File(resource.getFile());
    }
}

