/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.log.BufferedHandler;
import io.airlift.log.Format;
import io.airlift.log.LogFileName;
import io.airlift.log.MessageOutput;
import io.airlift.log.RollingFileMessageOutput;
import io.airlift.log.StaticFormatter;
import io.airlift.units.DataSize;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=5L, unit=TimeUnit.MINUTES)
public class TestRollingFileMessageOutput {
    public static final ImmutableMap<String, String> TESTING_ANNOTATIONS = ImmutableMap.of((Object)"environment", (Object)"testing");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicLogging() throws Exception {
        Path tempDir = Files.createTempDirectory("logging-test", new FileAttribute[0]);
        try {
            Path masterFile = tempDir.resolve("launcher.log");
            BufferedHandler handler = TestRollingFileMessageOutput.createRollingFileHandler(masterFile.toString(), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE), RollingFileMessageOutput.CompressionType.NONE, Format.TEXT.createFormatter(TESTING_ANNOTATIONS), new ErrorManager());
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
            Assertions.assertThat((Path)masterFile).exists();
            Assertions.assertThat((Path)masterFile).isSymbolicLink();
            handler.publish(new LogRecord(Level.SEVERE, "apple"));
            List<String> lines = TestRollingFileMessageOutput.waitForExactLines(masterFile, 1);
            Assertions.assertThat(lines).hasSize(1);
            ((ListAssert)Assertions.assertThat(lines).filteredOn(line -> line.contains("environment=testing"))).hasSize(1);
            ((ListAssert)Assertions.assertThat(lines).filteredOn(line -> line.contains("apple"))).hasSize(1);
            handler.publish(new LogRecord(Level.SEVERE, "banana"));
            lines = TestRollingFileMessageOutput.waitForExactLines(masterFile, 2);
            Assertions.assertThat(lines).hasSize(2);
            ((ListAssert)Assertions.assertThat(Files.readAllLines(masterFile, StandardCharsets.UTF_8)).filteredOn(line -> line.contains("banana"))).hasSize(1);
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
            handler.close();
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBrokenLink() throws Exception {
        Path tempDir = Files.createTempDirectory("logging-test", new FileAttribute[0]);
        try {
            Path masterFile = tempDir.resolve("launcher.log");
            Files.createSymbolicLink(masterFile, tempDir.resolve("launcher.log.broken"), new FileAttribute[0]);
            BufferedHandler handler = TestRollingFileMessageOutput.createRollingFileHandler(masterFile.toString(), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE), RollingFileMessageOutput.CompressionType.NONE, Format.TEXT.createFormatter(TESTING_ANNOTATIONS), new ErrorManager());
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
            Assertions.assertThat((Path)masterFile).exists();
            Assertions.assertThat((Path)masterFile).isSymbolicLink();
            handler.publish(new LogRecord(Level.SEVERE, "apple"));
            List<String> lines = TestRollingFileMessageOutput.waitForExactLines(masterFile, 1);
            Assertions.assertThat(lines).hasSize(1);
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
            handler.close();
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExistingDirectory() throws Exception {
        Path tempDir = Files.createTempDirectory("logging-test", new FileAttribute[0]);
        try {
            Path masterFile = tempDir.resolve("launcher.log");
            Files.createDirectories(masterFile, new FileAttribute[0]);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestRollingFileMessageOutput.createRollingFileHandler(masterFile.toString(), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE), RollingFileMessageOutput.CompressionType.NONE, Format.TEXT.createFormatter(TESTING_ANNOTATIONS), new ErrorManager())).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Log file is an existing directory");
            Files.delete(masterFile);
            Path someDirectory = tempDir.resolve("launcher.log.directory");
            Files.createDirectories(someDirectory, new FileAttribute[0]);
            Files.createSymbolicLink(masterFile, someDirectory, new FileAttribute[0]);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestRollingFileMessageOutput.createRollingFileHandler(masterFile.toString(), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE), RollingFileMessageOutput.CompressionType.NONE, Format.TEXT.createFormatter(TESTING_ANNOTATIONS), new ErrorManager())).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Log file is an existing directory");
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRollAndPrune() throws Exception {
        String message = Strings.padEnd((String)"", (int)99, (char)'x') + "\n";
        Path tempDir = Files.createTempDirectory("logging-test", new FileAttribute[0]);
        try {
            int i;
            Path masterFile = tempDir.resolve("launcher.log");
            BufferedHandler handler = TestRollingFileMessageOutput.createRollingFileHandler(masterFile.toString(), DataSize.of((long)((long)message.length() * 5L), (DataSize.Unit)DataSize.Unit.BYTE), DataSize.of((long)((long)message.length() * 2L + (long)message.length() * 5L + (long)message.length() * 5L), (DataSize.Unit)DataSize.Unit.BYTE), RollingFileMessageOutput.CompressionType.NONE, Format.TEXT.createFormatter((Map)ImmutableMap.of()), new ErrorManager());
            handler.setFormatter(new Formatter(this){

                @Override
                public String format(LogRecord record) {
                    return record.getMessage();
                }
            });
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
            TestRollingFileMessageOutput.assertLogSizes(masterFile, handler, 0, message.length(), 1);
            for (i = 0; i < 5; ++i) {
                handler.publish(new LogRecord(Level.SEVERE, message));
                TestRollingFileMessageOutput.assertLogSizes(masterFile, handler, i + 1, message.length(), 1);
            }
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
            for (i = 0; i < 5; ++i) {
                handler.publish(new LogRecord(Level.SEVERE, message));
                TestRollingFileMessageOutput.assertLogSizes(masterFile, handler, i + 1, message.length(), 2);
            }
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
            for (i = 0; i < 2; ++i) {
                handler.publish(new LogRecord(Level.SEVERE, message));
                TestRollingFileMessageOutput.assertLogSizes(masterFile, handler, i + 1, message.length(), 3);
            }
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
            for (i = 0; i < 3; ++i) {
                handler.publish(new LogRecord(Level.SEVERE, message));
                TestRollingFileMessageOutput.assertLogSizes(masterFile, handler, i + 3, message.length(), 2);
            }
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
            for (i = 0; i < 2; ++i) {
                handler.publish(new LogRecord(Level.SEVERE, message));
                TestRollingFileMessageOutput.assertLogSizes(masterFile, handler, i + 1, message.length(), 3);
            }
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
            for (i = 0; i < 3; ++i) {
                handler.publish(new LogRecord(Level.SEVERE, message));
                TestRollingFileMessageOutput.assertLogSizes(masterFile, handler, i + 3, message.length(), 2);
            }
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
            handler.close();
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompression() throws Exception {
        String message = Strings.padEnd((String)"", (int)9, (char)'x') + "\n";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (GZIPOutputStream compressOut = new GZIPOutputStream(out);){
            for (int i = 0; i < 5; ++i) {
                compressOut.write(message.getBytes(StandardCharsets.UTF_8));
            }
            compressOut.flush();
        }
        int expectedCompressedSize = out.toByteArray().length;
        Assertions.assertThat((int)expectedCompressedSize).isBetween(Integer.valueOf(message.length()), Integer.valueOf(message.length() * 5));
        Path tempDir = Files.createTempDirectory("logging-test", new FileAttribute[0]);
        try {
            int i;
            Path masterFile = tempDir.resolve("launcher.log");
            BufferedHandler handler = TestRollingFileMessageOutput.createRollingFileHandler(masterFile.toString(), DataSize.of((long)((long)message.length() * 5L), (DataSize.Unit)DataSize.Unit.BYTE), DataSize.of((long)((long)message.length() + (long)message.length() * 5L + (long)expectedCompressedSize), (DataSize.Unit)DataSize.Unit.BYTE), RollingFileMessageOutput.CompressionType.GZIP, Format.TEXT.createFormatter((Map)ImmutableMap.of()), new ErrorManager());
            handler.setFormatter(new Formatter(this){

                @Override
                public String format(LogRecord record) {
                    return record.getMessage();
                }
            });
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
            TestRollingFileMessageOutput.assertLogSizes(masterFile, handler, 0, message.length(), 1);
            for (i = 1; i < 6; ++i) {
                handler.publish(new LogRecord(Level.SEVERE, message));
                TestRollingFileMessageOutput.assertLogSizes(masterFile, handler, i, message.length(), 1);
            }
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
            handler.publish(new LogRecord(Level.SEVERE, message));
            TestRollingFileMessageOutput.assertCompression(masterFile, handler, message, 2, 5, expectedCompressedSize);
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
            for (i = 0; i < 4; ++i) {
                handler.publish(new LogRecord(Level.SEVERE, message));
            }
            TestRollingFileMessageOutput.assertCompression(masterFile, handler, message, 2, 5, expectedCompressedSize);
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
            handler.publish(new LogRecord(Level.SEVERE, message));
            TestRollingFileMessageOutput.assertCompression(masterFile, handler, message, 3, 5, expectedCompressedSize);
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
            for (i = 0; i < 4; ++i) {
                handler.publish(new LogRecord(Level.SEVERE, message));
            }
            TestRollingFileMessageOutput.assertLogSizes(masterFile, handler, 5, message.length(), 2);
            TestRollingFileMessageOutput.assertCompression(masterFile, handler, message, 2, 5, expectedCompressedSize);
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
            handler.close();
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClosedHandler() throws Exception {
        Path tempDir = Files.createTempDirectory("logging-test", new FileAttribute[0]);
        try {
            Path masterFile = tempDir.resolve("launcher.log");
            BufferedHandler handler = TestRollingFileMessageOutput.createRollingFileHandler(masterFile.toString(), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE), RollingFileMessageOutput.CompressionType.NONE, Format.TEXT.createFormatter(TESTING_ANNOTATIONS), new ErrorManager());
            handler.publish(new LogRecord(Level.SEVERE, "apple"));
            handler.publish(new LogRecord(Level.SEVERE, "banana"));
            handler.close();
            handler.publish(new LogRecord(Level.SEVERE, "cherry"));
            List<String> lines = TestRollingFileMessageOutput.waitForExactLines(masterFile, 2);
            Assertions.assertThat((int)lines.size()).isEqualTo(2);
            ((ListAssert)Assertions.assertThat(Files.readAllLines(masterFile, StandardCharsets.UTF_8)).filteredOn(line -> line.contains("apple") || line.contains("banana"))).hasSize(2);
            handler.flush();
            handler.close();
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoggingInExistingDirectory() throws Exception {
        Path tempDir = Files.createTempDirectory("logging-test", new FileAttribute[0]);
        try {
            Path masterFile = tempDir.resolve("launcher.log");
            BufferedHandler handler = TestRollingFileMessageOutput.createRollingFileHandler(masterFile.toString(), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE), RollingFileMessageOutput.CompressionType.NONE, Format.TEXT.createFormatter(TESTING_ANNOTATIONS), new ErrorManager());
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
            Path firstLogFile = Files.readSymbolicLink(masterFile);
            handler.publish(new LogRecord(Level.SEVERE, "apple"));
            handler.publish(new LogRecord(Level.SEVERE, "banana"));
            List<String> lines = TestRollingFileMessageOutput.waitForExactLines(masterFile, 2);
            Assertions.assertThat(lines).hasSize(2);
            ((ListAssert)Assertions.assertThat(Files.readAllLines(masterFile, StandardCharsets.UTF_8)).filteredOn(line -> line.contains("apple") || line.contains("banana"))).hasSize(2);
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
            handler.close();
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
            handler = TestRollingFileMessageOutput.createRollingFileHandler(masterFile.toString(), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE), RollingFileMessageOutput.CompressionType.NONE, Format.TEXT.createFormatter(TESTING_ANNOTATIONS), new ErrorManager());
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
            Assertions.assertThat((Path)Files.readSymbolicLink(masterFile)).isNotEqualTo((Object)firstLogFile);
            handler.publish(new LogRecord(Level.SEVERE, "cherry"));
            lines = TestRollingFileMessageOutput.waitForExactLines(masterFile, 1);
            Assertions.assertThat(lines).hasSize(1);
            ((ListAssert)Assertions.assertThat(lines).filteredOn(line -> line.contains("cherry"))).hasSize(1);
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
            handler.close();
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoggingInExistingLegacyDirectory() throws Exception {
        Path tempDir = Files.createTempDirectory("logging-test", new FileAttribute[0]);
        try {
            Path masterFile = tempDir.resolve("launcher.log");
            Files.writeString(masterFile, (CharSequence)new StaticFormatter().formatMessage(new LogRecord(Level.SEVERE, "apple")), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            Files.writeString(masterFile, (CharSequence)new StaticFormatter().formatMessage(new LogRecord(Level.SEVERE, "banana")), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            Assertions.assertThat((Path)masterFile).isRegularFile();
            List<String> lines = TestRollingFileMessageOutput.waitForExactLines(masterFile, 2);
            Assertions.assertThat(lines).hasSize(2);
            ((ListAssert)Assertions.assertThat(Files.readAllLines(masterFile, StandardCharsets.UTF_8)).filteredOn(line -> line.contains("apple") || line.contains("banana"))).hasSize(2);
            BufferedHandler newHandler = TestRollingFileMessageOutput.createRollingFileHandler(masterFile.toString(), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE), RollingFileMessageOutput.CompressionType.NONE, Format.TEXT.createFormatter(TESTING_ANNOTATIONS), new ErrorManager());
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
            Assertions.assertThat((Path)masterFile).isSymbolicLink();
            Assertions.assertThat((int)((RollingFileMessageOutput)newHandler.getMessageOutput()).getFiles().size()).isEqualTo(2);
            newHandler.publish(new LogRecord(Level.SEVERE, "cherry"));
            newHandler.publish(new LogRecord(Level.SEVERE, "date"));
            lines = TestRollingFileMessageOutput.waitForExactLines(masterFile, 2);
            Assertions.assertThat(lines).hasSize(2);
            ((ListAssert)Assertions.assertThat(lines).filteredOn(line -> line.contains("cherry") || line.contains("date"))).hasSize(2);
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
            newHandler.close();
            TestRollingFileMessageOutput.assertLogDirectory(masterFile);
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    private static BufferedHandler createRollingFileHandler(String filename, DataSize maxFileSize, DataSize maxTotalSize, RollingFileMessageOutput.CompressionType compressionType, Formatter formatter, ErrorManager errorManager) {
        RollingFileMessageOutput output = new RollingFileMessageOutput(filename, maxFileSize, maxTotalSize, compressionType);
        BufferedHandler handler = new BufferedHandler((MessageOutput)output, formatter, errorManager);
        handler.initialize();
        return handler;
    }

    private static void assertLogDirectory(Path masterFile) throws Exception {
        Assertions.assertThat((Path)masterFile.getParent()).isDirectory();
        Assertions.assertThat((Path)masterFile).isSymbolicLink();
        Path symbolicLinkTarget = Files.readSymbolicLink(masterFile);
        Assertions.assertThat((Path)symbolicLinkTarget).isRelative();
        Assertions.assertThat((int)symbolicLinkTarget.getNameCount()).isEqualTo(1);
        Assertions.assertThat((Path)symbolicLinkTarget).hasNoParentRaw();
        List logFiles = (List)Files.list(masterFile.getParent()).filter(Predicate.not(masterFile::equals)).collect(ImmutableList.toImmutableList());
        for (Path logFile : logFiles) {
            Assertions.assertThat((Path)logFile).isRegularFile();
            Assertions.assertThat((boolean)LogFileName.parseHistoryLogFileName((String)masterFile.getFileName().toString(), (String)logFile.getFileName().toString()).isPresent()).isTrue();
        }
    }

    private static void assertCompression(Path masterFile, BufferedHandler handler, String message, int expectedFileCount, int expectedLineCount, int expectedCompressedSize) throws Exception {
        Set<LogFileName> compressedFileNames = TestRollingFileMessageOutput.waitForCompression((RollingFileMessageOutput)handler.getMessageOutput(), expectedFileCount);
        Assertions.assertThat(compressedFileNames).hasSize(expectedFileCount - 1);
        for (LogFileName compressedFileName : compressedFileNames) {
            Path compressedFile = masterFile.resolveSibling(compressedFileName.getFileName());
            Assertions.assertThat((Path)compressedFile).hasSize((long)expectedCompressedSize);
            ImmutableList lines = new GzippedByteSource(MoreFiles.asByteSource((Path)compressedFile, (OpenOption[])new OpenOption[0])).asCharSource(StandardCharsets.UTF_8).readLines();
            Assertions.assertThat((List)lines).hasSize(expectedLineCount);
            Assertions.assertThat((List)lines).allMatch(message.trim()::equals);
        }
    }

    private static void assertLogSizes(Path masterFile, BufferedHandler handler, int expectedLines, int lineSize, int expectedFileCount) throws Exception {
        Set<LogFileName> files = TestRollingFileMessageOutput.waitForExactFiles((RollingFileMessageOutput)handler.getMessageOutput(), expectedFileCount);
        Assertions.assertThat(files).hasSize(expectedFileCount);
        List<String> lines = TestRollingFileMessageOutput.waitForExactLines(masterFile, expectedLines);
        Assertions.assertThat(lines).hasSize(expectedLines);
        Assertions.assertThat((Path)masterFile).hasSize((long)expectedLines * (long)lineSize);
    }

    private static List<String> waitForExactLines(Path masterFile, int exactCount) throws IOException, InterruptedException {
        List<String> lines;
        while ((lines = Files.readAllLines(masterFile, StandardCharsets.UTF_8)).size() != exactCount) {
            Thread.sleep(10L);
        }
        return lines;
    }

    private static Set<LogFileName> waitForExactFiles(RollingFileMessageOutput fileHandler, int exactCount) throws Exception {
        Set files;
        while ((files = fileHandler.getFiles()).size() != exactCount) {
            Thread.sleep(10L);
        }
        return files;
    }

    private static Set<LogFileName> waitForCompression(RollingFileMessageOutput fileHandler, int exactCount) throws Exception {
        Set compressedFiles;
        Set files;
        while ((files = fileHandler.getFiles()).size() != exactCount || (compressedFiles = (Set)files.stream().filter(LogFileName::isCompressed).collect(ImmutableSet.toImmutableSet())).size() != exactCount - 1) {
            Thread.sleep(10L);
        }
        return compressedFiles;
    }

    private static class GzippedByteSource
    extends ByteSource {
        private final ByteSource source;

        public GzippedByteSource(ByteSource gzippedSource) {
            this.source = gzippedSource;
        }

        public InputStream openStream() throws IOException {
            return new GZIPInputStream(this.source.openStream());
        }
    }
}

