/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.airlift.log.LoggingOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

public class TestLoggingOutputStream {
    @Test
    public void testStripTrailingNewline() {
        for (Map.Entry<String, String> testCase : TestLoggingOutputStream.testStripTrailingNewlineDataProvider().entrySet()) {
            String printed = testCase.getKey();
            String logged = testCase.getValue();
            MockHandler handler = new MockHandler();
            java.util.logging.Logger mockLogger = java.util.logging.Logger.getAnonymousLogger();
            mockLogger.setUseParentHandlers(false);
            mockLogger.setLevel(Level.ALL);
            mockLogger.addHandler(handler);
            PrintStream stream = new PrintStream((OutputStream)new LoggingOutputStream(new Logger(mockLogger)), true);
            stream.println(printed);
            this.assertLog(handler.takeRecord(), Level.INFO, logged);
            Assertions.assertThat((boolean)handler.isEmpty()).isTrue();
        }
    }

    public static Map<String, String> testStripTrailingNewlineDataProvider() {
        return ImmutableMap.of((Object)"Greeting from Warsaw!", (Object)"Greeting from Warsaw!", (Object)"many new lines:\n\n", (Object)"many new lines:", (Object)"trailing spaces and tabs \t", (Object)"trailing spaces and tabs", (Object)"intra \t  n \n rn \r\n whitespace", (Object)"intra \t  n \n rn \r\n whitespace");
    }

    private void assertLog(LogRecord record, Level level, String message) {
        Assertions.assertThat((Object)record.getLevel()).isEqualTo((Object)level);
        Assertions.assertThat((String)record.getMessage()).isEqualTo(message);
        Assertions.assertThat((Throwable)record.getThrown()).isNull();
    }

    private static class MockHandler
    extends Handler {
        private final List<LogRecord> records = new ArrayList<LogRecord>();

        private MockHandler() {
            this.setLevel(Level.ALL);
        }

        @Override
        public void publish(LogRecord record) {
            this.records.add(record);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        public LogRecord takeRecord() {
            ((ListAssert)Assertions.assertThat(this.records).as("No messages logged", new Object[0])).isNotEmpty();
            return this.records.remove(0);
        }

        public boolean isEmpty() {
            return this.records.isEmpty();
        }
    }
}

