/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import io.airlift.log.Logging;
import io.airlift.log.LoggingMBean;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestLoggingMBean {
    private final LoggingMBean logging = new LoggingMBean(Logging.initialize());
    private String rootLevel;

    @BeforeEach
    public void setRootLevel() {
        this.rootLevel = this.logging.getRootLevel();
        this.logging.setRootLevel("INFO");
    }

    @AfterEach
    public void restoreRootLevel() {
        this.logging.setRootLevel(this.rootLevel);
    }

    @Test
    public void testGetAndSetRoot() {
        Assertions.assertThat((String)this.logging.getRootLevel()).isEqualTo("INFO");
        this.logging.setRootLevel("WARN");
        Assertions.assertThat((String)this.logging.getRootLevel()).isEqualTo("WARN");
        this.logging.setRootLevel("INFO");
        Assertions.assertThat((String)this.logging.getRootLevel()).isEqualTo("INFO");
    }

    @Test
    public void testGetAndSetNonExisting() {
        Assertions.assertThat((String)this.logging.getRootLevel()).isEqualTo("INFO");
        String name = "this.logger.does.not.exist.yet.Bogus";
        Assertions.assertThat((Map)this.logging.getAllLevels()).doesNotContainKey((Object)name);
        Assertions.assertThat((String)this.logging.getLevel(name)).isEqualTo("INFO");
        this.logging.setLevel(name, "WARN");
        Assertions.assertThat((String)this.logging.getLevel(name)).isEqualTo("WARN");
        Assertions.assertThat((Map)this.logging.getAllLevels()).containsKey((Object)name);
        Assertions.assertThat((String)this.logging.getRootLevel()).isEqualTo("INFO");
    }

    @Test
    public void testSetInvalidLevel() {
        Assertions.assertThat((String)this.logging.getRootLevel()).isEqualTo("INFO");
        try {
            this.logging.setRootLevel("FOO");
            Assertions.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assertions.assertThat((String)this.logging.getRootLevel()).isEqualTo("INFO");
    }
}

