/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.log.Format;
import io.airlift.log.LoggingConfiguration;
import io.airlift.log.RollingFileMessageOutput;
import io.airlift.units.DataSize;
import java.io.File;
import java.util.Map;
import org.assertj.core.util.Files;
import org.junit.jupiter.api.Test;

public class TestLoggingConfiguration {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((LoggingConfiguration)ConfigAssertions.recordDefaults(LoggingConfiguration.class)).setConsoleEnabled(true).setLogPath(null).setMaxSize(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxTotalSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setCompression(RollingFileMessageOutput.CompressionType.GZIP).setLevelsFile(null).setFormat(Format.TEXT).setLogAnnotationFile(null));
    }

    @Test
    public void testExplicitPropertyMappings() {
        File annotationFile = Files.newTemporaryFile();
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"log.enable-console", (Object)"false").put((Object)"log.path", (Object)"/tmp/log.log").put((Object)"log.max-size", (Object)"1kB").put((Object)"log.max-total-size", (Object)"33kB").put((Object)"log.compression", (Object)"NONE").put((Object)"log.levels-file", (Object)"/tmp/levels.txt").put((Object)"log.format", (Object)"json").put((Object)"node.annotation-file", (Object)annotationFile.getAbsolutePath()).build();
        LoggingConfiguration expected = new LoggingConfiguration().setConsoleEnabled(false).setLogPath("/tmp/log.log").setMaxSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setMaxTotalSize(DataSize.of((long)33L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setCompression(RollingFileMessageOutput.CompressionType.NONE).setLevelsFile("/tmp/levels.txt").setFormat(Format.JSON).setLogAnnotationFile(annotationFile.getAbsolutePath());
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

