/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.log.Level;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.airlift.log.LoggingConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestLogging {
    private File tempDir;

    @BeforeEach
    public void setup() throws IOException {
        this.tempDir = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
    }

    @AfterEach
    public void tearDown() throws IOException {
        MoreFiles.deleteRecursively((Path)this.tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testRecoverTempFiles() throws IOException {
        LoggingConfiguration configuration = new LoggingConfiguration();
        configuration.setLogPath(new File(this.tempDir, "launcher.log").getPath());
        File logFile1 = new File(this.tempDir, "test1.log");
        com.google.common.io.Files.touch((File)logFile1);
        File logFile2 = new File(this.tempDir, "test2.log");
        com.google.common.io.Files.touch((File)logFile2);
        File tempLogFile1 = new File(this.tempDir, "temp1.tmp");
        com.google.common.io.Files.touch((File)tempLogFile1);
        File tempLogFile2 = new File(this.tempDir, "temp2.tmp");
        com.google.common.io.Files.touch((File)tempLogFile2);
        Logging logging = Logging.initialize();
        logging.configure(configuration);
        Assertions.assertThat((File)logFile1).exists();
        Assertions.assertThat((File)logFile2).exists();
        Assertions.assertThat((File)tempLogFile1).doesNotExist();
        Assertions.assertThat((File)tempLogFile2).doesNotExist();
        Assertions.assertThat((File)new File(this.tempDir, "temp1.log")).exists();
        Assertions.assertThat((File)new File(this.tempDir, "temp2.log")).exists();
    }

    @Test
    public void testPropagatesLevels() {
        Logging logging = Logging.initialize();
        Logger logger = Logger.get((String)"testPropagatesLevels");
        logging.setLevel("testPropagatesLevels", Level.ERROR);
        Assertions.assertThat((boolean)logger.isDebugEnabled()).isFalse();
        Assertions.assertThat((boolean)logger.isInfoEnabled()).isFalse();
        logging.setLevel("testPropagatesLevels", Level.WARN);
        Assertions.assertThat((boolean)logger.isDebugEnabled()).isFalse();
        Assertions.assertThat((boolean)logger.isInfoEnabled()).isFalse();
        logging.setLevel("testPropagatesLevels", Level.INFO);
        Assertions.assertThat((boolean)logger.isDebugEnabled()).isFalse();
        Assertions.assertThat((boolean)logger.isInfoEnabled()).isTrue();
        logging.setLevel("testPropagatesLevels", Level.DEBUG);
        Assertions.assertThat((boolean)logger.isDebugEnabled()).isTrue();
        Assertions.assertThat((boolean)logger.isInfoEnabled()).isTrue();
    }

    @Test
    public void testPropagatesLevelsHierarchical() {
        Logging logging = Logging.initialize();
        Logger logger = Logger.get((String)"testPropagatesLevelsHierarchical.child");
        logging.setLevel("testPropagatesLevelsHierarchical", Level.ERROR);
        Assertions.assertThat((boolean)logger.isDebugEnabled()).isFalse();
        Assertions.assertThat((boolean)logger.isInfoEnabled()).isFalse();
        logging.setLevel("testPropagatesLevelsHierarchical", Level.WARN);
        Assertions.assertThat((boolean)logger.isDebugEnabled()).isFalse();
        Assertions.assertThat((boolean)logger.isInfoEnabled()).isFalse();
        logging.setLevel("testPropagatesLevelsHierarchical", Level.INFO);
        Assertions.assertThat((boolean)logger.isDebugEnabled()).isFalse();
        Assertions.assertThat((boolean)logger.isInfoEnabled()).isTrue();
        logging.setLevel("testPropagatesLevelsHierarchical", Level.DEBUG);
        Assertions.assertThat((boolean)logger.isDebugEnabled()).isTrue();
        Assertions.assertThat((boolean)logger.isInfoEnabled()).isTrue();
    }

    @Test
    public void testChildLevelOverridesParent() {
        Logging logging = Logging.initialize();
        Logger logger = Logger.get((String)"testChildLevelOverridesParent.child");
        logging.setLevel("testChildLevelOverridesParent", Level.DEBUG);
        logging.setLevel("testChildLevelOverridesParent.child", Level.ERROR);
        Assertions.assertThat((boolean)logger.isDebugEnabled()).isFalse();
        Assertions.assertThat((boolean)logger.isInfoEnabled()).isFalse();
    }

    @Test
    public void testClearLevel() {
        Logging logging = Logging.initialize();
        Logger logger = Logger.get((String)"testClearLevel");
        logging.setLevel("testClearLevel", Level.DEBUG);
        Assertions.assertThat((boolean)logger.isDebugEnabled()).isTrue();
        logging.clearLevel("testClearLevel");
        Assertions.assertThat((boolean)logger.isDebugEnabled()).isFalse();
    }
}

