/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import io.airlift.log.LogFileName;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.Optional;
import java.util.OptionalInt;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLogFileName {
    private static final String BASE_NAME = "server.log";

    @Test
    public void testNew() {
        TestLogFileName.assertLogFile("20201122.010203", LocalDateTime.of(2020, 11, 22, 1, 2, 3), OptionalInt.of(0), OptionalInt.empty(), false);
        TestLogFileName.assertLogFile("20201122.010203-4", LocalDateTime.of(2020, 11, 22, 1, 2, 3), OptionalInt.of(4), OptionalInt.empty(), false);
        TestLogFileName.assertLogFile("20201122.010203.gz", LocalDateTime.of(2020, 11, 22, 1, 2, 3), OptionalInt.of(0), OptionalInt.empty(), true);
        TestLogFileName.assertLogFile("20201122.010203-4.gz", LocalDateTime.of(2020, 11, 22, 1, 2, 3), OptionalInt.of(4), OptionalInt.empty(), true);
    }

    @Test
    public void testLegacy() {
        TestLogFileName.assertLogFile("2020-11-22.4.log", LocalDateTime.of(2020, 11, 22, 0, 0), OptionalInt.empty(), OptionalInt.of(4), false);
        TestLogFileName.assertLogFile("2020-11-22.4.log.gz", LocalDateTime.of(2020, 11, 22, 0, 0), OptionalInt.empty(), OptionalInt.of(4), true);
    }

    @Test
    public void testComparisonNew() {
        TestLogFileName.assertOrdering(TestLogFileName.createLogFile("20201122.010203"), TestLogFileName.createLogFile("20201122.010204"));
        TestLogFileName.assertOrdering(TestLogFileName.createLogFile("20201122.010203"), TestLogFileName.createLogFile("20201122.010203-1"));
        TestLogFileName.assertOrdering(TestLogFileName.createLogFile("20201122.010203-1"), TestLogFileName.createLogFile("20201122.010203-2"));
        TestLogFileName.assertOrdering(TestLogFileName.createLogFile("20201122.010203-apple"), TestLogFileName.createLogFile("20201122.010203-2"));
        TestLogFileName.assertOrdering(TestLogFileName.createLogFile("20201122.010203"), TestLogFileName.createLogFile("20201122.010203-apple"));
        TestLogFileName.assertOrdering(TestLogFileName.createLogFile("20201122.010203-apple"), TestLogFileName.createLogFile("20201122.010203-banana"));
        TestLogFileName.assertEqualOrdering(TestLogFileName.createLogFile("20201122.010203.gz"), TestLogFileName.createLogFile("20201122.010203"));
    }

    @Test
    public void testComparisonLegacy() {
        TestLogFileName.assertOrdering(TestLogFileName.createLogFile("2020-11-22.0.log"), TestLogFileName.createLogFile("2020-11-23.0.log"));
        TestLogFileName.assertOrdering(TestLogFileName.createLogFile("2020-11-22.2.log"), TestLogFileName.createLogFile("2020-11-22.1.log"));
        TestLogFileName.assertEqualOrdering(TestLogFileName.createLogFile("2020-11-22.1.log.gz"), TestLogFileName.createLogFile("2020-11-22.1.log"));
    }

    @Test
    public void testComparisonNewAndLegacy() {
        TestLogFileName.assertOrdering(TestLogFileName.createLogFile("20201122.010203"), TestLogFileName.createLogFile("2020-11-23.0.log"));
        TestLogFileName.assertOrdering(TestLogFileName.createLogFile("2020-11-22.0.log"), TestLogFileName.createLogFile("20201122.010203"));
        TestLogFileName.assertOrdering(TestLogFileName.createLogFile("20201122.000000"), TestLogFileName.createLogFile("2020-11-22.0.log"));
        TestLogFileName.assertOrdering(TestLogFileName.createLogFile("20201122.000000-100"), TestLogFileName.createLogFile("2020-11-22.0.log"));
        TestLogFileName.assertOrdering(TestLogFileName.createLogFile("20201122.000000-apple"), TestLogFileName.createLogFile("2020-11-22.0.log"));
        TestLogFileName.assertOrdering(TestLogFileName.createLogFile("20201122.000000.gz"), TestLogFileName.createLogFile("2020-11-22.0.log"));
        TestLogFileName.assertOrdering(TestLogFileName.createLogFile("20201122.000000"), TestLogFileName.createLogFile("2020-11-22.0.log.gz"));
    }

    @Test
    public void testGenerateNextLogFileName() {
        LogFileName logFileName = LogFileName.generateNextLogFileName((Path)Paths.get(BASE_NAME, new String[0]), Optional.empty());
        Assertions.assertThat((OptionalInt)logFileName.getIndex()).isEqualTo((Object)OptionalInt.of(0));
        Assertions.assertThat((OptionalInt)logFileName.getLegacyIndex()).isEqualTo((Object)OptionalInt.empty());
        TestLogFileName.assertEqualOrdering((LogFileName)LogFileName.parseHistoryLogFileName((String)BASE_NAME, (String)logFileName.getFileName()).orElseThrow(AssertionError::new), logFileName);
    }

    private static LogFileName createLogFile(String suffix) {
        return (LogFileName)LogFileName.parseHistoryLogFileName((String)BASE_NAME, (String)("server.log-" + suffix)).orElseThrow(AssertionError::new);
    }

    private static void assertLogFile(String suffix, LocalDateTime dateTime, OptionalInt index, OptionalInt legacyIndex, boolean compressed) {
        Path path = Paths.get("server.log-" + suffix, new String[0]);
        Optional logFile = LogFileName.parseHistoryLogFileName((String)BASE_NAME, (String)path.getFileName().toString());
        Assertions.assertThat((Optional)logFile).isPresent();
        Assertions.assertThat((LocalDateTime)((LogFileName)logFile.get()).getDateTime()).isEqualTo((Object)dateTime);
        Assertions.assertThat((OptionalInt)((LogFileName)logFile.get()).getIndex()).isEqualTo((Object)index);
        Assertions.assertThat((OptionalInt)((LogFileName)logFile.get()).getLegacyIndex()).isEqualTo((Object)legacyIndex);
        Assertions.assertThat((Optional)((LogFileName)logFile.get()).getSlug()).isEqualTo(Optional.empty());
        Assertions.assertThat((boolean)((LogFileName)logFile.get()).isCompressed()).isEqualTo(compressed);
    }

    private static void assertOrdering(LogFileName ... logFileNames) {
        Assertions.assertThat((boolean)Comparators.isInStrictOrder((Iterable)ImmutableList.copyOf((Object[])logFileNames), Comparator.naturalOrder())).isTrue();
    }

    private static void assertEqualOrdering(LogFileName ... logFileNames) {
        Assertions.assertThat((boolean)Comparators.isInOrder((Iterable)ImmutableList.copyOf((Object[])logFileNames), Comparator.naturalOrder())).isTrue();
        Assertions.assertThat((boolean)Comparators.isInStrictOrder((Iterable)ImmutableList.copyOf((Object[])logFileNames), Comparator.naturalOrder())).isFalse();
    }
}

