/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import io.airlift.log.Logger;
import io.airlift.log.LoggingOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestLoggingOutputStream {
    @Test(dataProvider="testStripTrailingNewlineDataProvider")
    public void testStripTrailingNewline(String printed, String logged) {
        MockHandler handler = new MockHandler();
        java.util.logging.Logger mockLogger = java.util.logging.Logger.getAnonymousLogger();
        mockLogger.setUseParentHandlers(false);
        mockLogger.setLevel(Level.ALL);
        mockLogger.addHandler(handler);
        PrintStream stream = new PrintStream((OutputStream)new LoggingOutputStream(new Logger(mockLogger)), true);
        stream.println(printed);
        this.assertLog(handler.takeRecord(), Level.INFO, logged);
        Assert.assertTrue((boolean)handler.isEmpty());
    }

    @DataProvider
    public static Object[][] testStripTrailingNewlineDataProvider() {
        return new Object[][]{{"Greeting from Warsaw!", "Greeting from Warsaw!"}, {"many new lines:\n\n", "many new lines:"}, {"trailing spaces and tabs \t", "trailing spaces and tabs"}, {"intra \t  n \n rn \r\n whitespace", "intra \t  n \n rn \r\n whitespace"}};
    }

    private void assertLog(LogRecord record, Level level, String message) {
        Assert.assertEquals((Object)record.getLevel(), (Object)level);
        Assert.assertEquals((String)record.getMessage(), (String)message);
        Assert.assertNull((Object)record.getThrown());
    }

    private static class MockHandler
    extends Handler {
        private final List<LogRecord> records = new ArrayList<LogRecord>();

        private MockHandler() {
            this.setLevel(Level.ALL);
        }

        @Override
        public void publish(LogRecord record) {
            this.records.add(record);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        public LogRecord takeRecord() {
            Assert.assertFalse((boolean)this.records.isEmpty(), (String)"No messages logged");
            return this.records.remove(0);
        }

        public boolean isEmpty() {
            return this.records.isEmpty();
        }
    }
}

