/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import com.google.common.collect.ImmutableList;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.log.LogFileName;
import io.airlift.log.LogHistoryManager;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLogHistoryManager {
    private static final int FILE_SIZE = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitialLoad() throws IOException {
        Path tempDir = Files.createTempDirectory("logging-test", new FileAttribute[0]);
        try {
            Path masterLogName = tempDir.resolve("test");
            ArrayList<LogFileName> logFileNames = new ArrayList<LogFileName>();
            for (int i = 0; i < 100; ++i) {
                logFileNames.add(TestLogHistoryManager.createTestFile(masterLogName));
            }
            LogHistoryManager logHistoryManager = new LogHistoryManager(masterLogName, new DataSize(1.0, DataSize.Unit.GIGABYTE));
            TestLogHistoryManager.assertLogFiles(logHistoryManager, logFileNames);
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitialPrune() throws IOException {
        Path tempDir = Files.createTempDirectory("logging-test", new FileAttribute[0]);
        try {
            Path masterLogName = tempDir.resolve("test");
            ArrayList<LogFileName> logFileNames = new ArrayList<LogFileName>();
            for (int i = 0; i < 100; ++i) {
                logFileNames.add(TestLogHistoryManager.createTestFile(masterLogName));
            }
            LogHistoryManager logHistoryManager = new LogHistoryManager(masterLogName, new DataSize(1000.0, DataSize.Unit.BYTE));
            TestLogHistoryManager.assertLogFiles(logHistoryManager, logFileNames.subList(90, logFileNames.size()));
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    private static void assertLogFiles(LogHistoryManager logHistoryManager, List<LogFileName> expected) {
        Assert.assertEquals((long)logHistoryManager.getTotalSize(), (long)(expected.size() * 100));
        List files = (List)logHistoryManager.getFiles().stream().sorted().collect(ImmutableList.toImmutableList());
        Assert.assertEquals((Collection)files, expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRuntimePrune() throws IOException, InterruptedException {
        Path tempDir = Files.createTempDirectory("logging-test", new FileAttribute[0]);
        try {
            LogFileName testFile;
            int i;
            Path masterLogName = tempDir.resolve("test");
            List<Object> logFileNames = new ArrayList<LogFileName>();
            for (int i2 = 0; i2 < 100; ++i2) {
                logFileNames.add(TestLogHistoryManager.createTestFile(masterLogName));
            }
            LogHistoryManager logHistoryManager = new LogHistoryManager(masterLogName, new DataSize(10000.0, DataSize.Unit.BYTE));
            TestLogHistoryManager.assertLogFiles(logHistoryManager, logFileNames);
            Thread.sleep(2000L);
            for (i = 0; i < 2; ++i) {
                testFile = TestLogHistoryManager.createTestFile(masterLogName);
                logHistoryManager.addFile(masterLogName.resolveSibling(testFile.getFileName()), testFile, 100L);
                logFileNames.add(testFile);
            }
            TestLogHistoryManager.assertLogFiles(logHistoryManager, logFileNames);
            logHistoryManager.pruneLogFilesIfNecessary(0L);
            logFileNames = logFileNames.subList(2, logFileNames.size());
            TestLogHistoryManager.assertLogFiles(logHistoryManager, logFileNames);
            logHistoryManager.pruneLogFilesIfNecessary(200L);
            logFileNames = logFileNames.subList(2, logFileNames.size());
            TestLogHistoryManager.assertLogFiles(logHistoryManager, logFileNames);
            Thread.sleep(2000L);
            for (i = 0; i < 4; ++i) {
                testFile = TestLogHistoryManager.createTestFile(masterLogName);
                logHistoryManager.addFile(masterLogName.resolveSibling(testFile.getFileName()), testFile, 100L);
                logFileNames.add(testFile);
            }
            TestLogHistoryManager.assertLogFiles(logHistoryManager, logFileNames);
            logHistoryManager.pruneLogFilesIfNecessary(200L);
            logFileNames = logFileNames.subList(4, logFileNames.size());
            TestLogHistoryManager.assertLogFiles(logHistoryManager, logFileNames);
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    private static LogFileName createTestFile(Path masterLogName) throws IOException {
        LogFileName logFileName = LogFileName.generateNextLogFileName((Path)masterLogName, Optional.empty());
        Files.write(masterLogName.resolveSibling(logFileName.getFileName()), new byte[100], StandardOpenOption.CREATE_NEW);
        return logFileName;
    }
}

