/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.log.Level;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.airlift.log.LoggingConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestLogging {
    private File tempDir;

    @BeforeMethod
    public void setup() throws IOException {
        this.tempDir = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws IOException {
        MoreFiles.deleteRecursively((Path)this.tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testRecoverTempFiles() throws IOException {
        LoggingConfiguration configuration = new LoggingConfiguration();
        configuration.setLogPath(new File(this.tempDir, "launcher.log").getPath());
        File logFile1 = new File(this.tempDir, "test1.log");
        com.google.common.io.Files.touch((File)logFile1);
        File logFile2 = new File(this.tempDir, "test2.log");
        com.google.common.io.Files.touch((File)logFile2);
        File tempLogFile1 = new File(this.tempDir, "temp1.tmp");
        com.google.common.io.Files.touch((File)tempLogFile1);
        File tempLogFile2 = new File(this.tempDir, "temp2.tmp");
        com.google.common.io.Files.touch((File)tempLogFile2);
        Logging logging = Logging.initialize();
        logging.configure(configuration);
        Assert.assertTrue((boolean)logFile1.exists());
        Assert.assertTrue((boolean)logFile2.exists());
        Assert.assertFalse((boolean)tempLogFile1.exists());
        Assert.assertFalse((boolean)tempLogFile2.exists());
        Assert.assertTrue((boolean)new File(this.tempDir, "temp1.log").exists());
        Assert.assertTrue((boolean)new File(this.tempDir, "temp2.log").exists());
    }

    @Test
    public void testPropagatesLevels() throws Exception {
        Logging logging = Logging.initialize();
        Logger logger = Logger.get((String)"testPropagatesLevels");
        logging.setLevel("testPropagatesLevels", Level.ERROR);
        Assert.assertFalse((boolean)logger.isDebugEnabled());
        Assert.assertFalse((boolean)logger.isInfoEnabled());
        logging.setLevel("testPropagatesLevels", Level.WARN);
        Assert.assertFalse((boolean)logger.isDebugEnabled());
        Assert.assertFalse((boolean)logger.isInfoEnabled());
        logging.setLevel("testPropagatesLevels", Level.INFO);
        Assert.assertFalse((boolean)logger.isDebugEnabled());
        Assert.assertTrue((boolean)logger.isInfoEnabled());
        logging.setLevel("testPropagatesLevels", Level.DEBUG);
        Assert.assertTrue((boolean)logger.isDebugEnabled());
        Assert.assertTrue((boolean)logger.isInfoEnabled());
    }

    @Test
    public void testPropagatesLevelsHierarchical() throws Exception {
        Logging logging = Logging.initialize();
        Logger logger = Logger.get((String)"testPropagatesLevelsHierarchical.child");
        logging.setLevel("testPropagatesLevelsHierarchical", Level.ERROR);
        Assert.assertFalse((boolean)logger.isDebugEnabled());
        Assert.assertFalse((boolean)logger.isInfoEnabled());
        logging.setLevel("testPropagatesLevelsHierarchical", Level.WARN);
        Assert.assertFalse((boolean)logger.isDebugEnabled());
        Assert.assertFalse((boolean)logger.isInfoEnabled());
        logging.setLevel("testPropagatesLevelsHierarchical", Level.INFO);
        Assert.assertFalse((boolean)logger.isDebugEnabled());
        Assert.assertTrue((boolean)logger.isInfoEnabled());
        logging.setLevel("testPropagatesLevelsHierarchical", Level.DEBUG);
        Assert.assertTrue((boolean)logger.isDebugEnabled());
        Assert.assertTrue((boolean)logger.isInfoEnabled());
    }

    @Test
    public void testChildLevelOverridesParent() throws Exception {
        Logging logging = Logging.initialize();
        Logger logger = Logger.get((String)"testChildLevelOverridesParent.child");
        logging.setLevel("testChildLevelOverridesParent", Level.DEBUG);
        logging.setLevel("testChildLevelOverridesParent.child", Level.ERROR);
        Assert.assertFalse((boolean)logger.isDebugEnabled());
        Assert.assertFalse((boolean)logger.isInfoEnabled());
    }

    @Test
    public void testClearLevel() throws Exception {
        Logging logging = Logging.initialize();
        Logger logger = Logger.get((String)"testClearLevel");
        logging.setLevel("testClearLevel", Level.DEBUG);
        Assert.assertTrue((boolean)logger.isDebugEnabled());
        logging.clearLevel("testClearLevel");
        Assert.assertFalse((boolean)logger.isDebugEnabled());
    }
}

