/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multiset;
import com.google.common.io.ByteStreams;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.RateLimiter;
import io.airlift.log.BufferedHandler;
import io.airlift.log.Format;
import io.airlift.log.Level;
import io.airlift.log.MessageOutput;
import io.airlift.log.SocketMessageOutput;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(timeOut=300000L)
public class TestSocketHandler {
    @Test
    public void testSocketLogging() throws IOException {
        String[] data = new String[]{"apple", "banana", "orange"};
        java.util.logging.Level[] levels = new java.util.logging.Level[]{java.util.logging.Level.SEVERE, java.util.logging.Level.INFO, java.util.logging.Level.WARNING};
        try (ServerSocket serverSocket = new ServerSocket(0);){
            Executors.newSingleThreadExecutor().submit(() -> {
                BufferedHandler handler = TestSocketHandler.createSocketHandler(HostAndPort.fromParts((String)"localhost", (int)serverSocket.getLocalPort()), Format.TEXT.createFormatter((Map)ImmutableMap.of()), new ErrorManager());
                for (int i = 0; i < data.length; ++i) {
                    handler.publish(new LogRecord(levels[i], data[i]));
                }
                handler.flush();
                handler.close();
            });
            try (Socket listeningSocket = serverSocket.accept();
                 InputStream inputStream = listeningSocket.getInputStream();){
                String received = new String(ByteStreams.toByteArray((InputStream)inputStream), StandardCharsets.UTF_8);
                String[] lines = received.split("\n");
                for (int i = 0; i < lines.length; ++i) {
                    String[] parts = lines[i].split("\t");
                    Assert.assertEquals((String)parts[1], (String)Level.fromJulLevel((java.util.logging.Level)levels[i]).toString());
                    Assert.assertEquals((String)parts[4], (String)data[i]);
                }
            }
        }
    }

    @Test
    public void testBadListeningSocket() throws IOException {
        ServerSocket serverSocket = new ServerSocket(0);
        int unallocatedPort = serverSocket.getLocalPort();
        serverSocket.close();
        BufferedHandler handler = TestSocketHandler.createSocketHandler(HostAndPort.fromParts((String)"localhost", (int)unallocatedPort), Format.TEXT.createFormatter((Map)ImmutableMap.of()), new ErrorManager());
        handler.publish(new LogRecord(java.util.logging.Level.SEVERE, "rutabaga"));
        handler.flush();
        handler.close();
        Assert.assertTrue((((SocketMessageOutput)handler.getMessageOutput()).getFailedConnections() > 0L ? 1 : 0) != 0);
    }

    private static BufferedHandler createSocketHandler(HostAndPort hostAndPort, Formatter formatter, ErrorManager errorManager) {
        SocketMessageOutput output = new SocketMessageOutput(hostAndPort);
        BufferedHandler handler = new BufferedHandler((MessageOutput)output, formatter, Multiset::toString, errorManager, RateLimiter.create((double)10.0), Duration.ofMillis(100L), 512, 1024);
        handler.initialize();
        return handler;
    }
}

