/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.airlift.log.JsonFormatter;
import io.airlift.log.JsonRecord;
import io.airlift.log.Level;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.logging.LogRecord;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.MapAssert;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestJsonFormatter {
    @Test
    public void testMinimalJsonErrorLogLine() {
        JsonRecord original = new JsonRecord(Instant.now(), Level.DEBUG, "thread-0", "TestLogger", "Test Log Message", (Throwable)new Exception("Test Exception 1"), Context.root(), (Map)ImmutableMap.of());
        RuntimeException exception = new RuntimeException("Test Exception 2");
        String minimalJsonErrorLogLine = new JsonFormatter((Map)ImmutableMap.of()).minimalJsonErrorLogLine(original, (Exception)exception);
        ((AbstractStringAssert)Assertions.assertThat((String)minimalJsonErrorLogLine).as("Log lines should end with newline", new Object[0])).endsWith((CharSequence)"\n");
        Assert.assertEquals((Object)JsonCodec.jsonCodec(JsonRecord.class).fromJson(minimalJsonErrorLogLine), (Object)new JsonRecord(original.getTimestamp(), Level.ERROR, null, null, exception.getMessage(), null, Context.root(), (Map)ImmutableMap.of()));
    }

    @Test
    public void testMinimalRecordFormatting() {
        LogRecord record = new LogRecord(Level.DEBUG.toJulLevel(), "Testing");
        record.setLoggerName("TestLogger");
        Assertions.assertThat((String)new JsonFormatter((Map)ImmutableMap.of()).format(record)).matches((CharSequence)"\\{\"timestamp\":\".*\",\"level\":\"DEBUG\",\"thread\":\".*\",\"logger\":\"TestLogger\",\"message\":\"Testing\"}\n");
    }

    @Test
    public void testRoundTrip() {
        JsonRecord original = new JsonRecord(Instant.now(), Level.DEBUG, "thread-0", "TestLogger", "Test Log Message", (Throwable)new Exception("Test Exception 1"), Context.root(), (Map)ImmutableMap.of());
        Assert.assertEquals((Object)JsonCodec.jsonCodec(JsonRecord.class).fromJson(JsonCodec.jsonCodec(JsonRecord.class).toJson((Object)original)), (Object)new JsonRecord(original.getTimestamp(), original.getLevel(), original.getThread(), original.getLoggerName(), original.getMessage(), null, Context.root(), (Map)ImmutableMap.of()));
    }

    @Test
    public void testLogFormatting() {
        RuntimeException testException = new RuntimeException("Test Exception");
        LogRecord record = new LogRecord(Level.DEBUG.toJulLevel(), "Test Log Message");
        record.setLoggerName("TestLogger");
        record.setThrown(testException);
        String logMessage = new JsonFormatter((Map)ImmutableMap.of()).format(record);
        Map jsonMap = (Map)JsonCodec.mapJsonCodec(String.class, Object.class).fromJson(logMessage);
        JsonRecord jsonRecord = (JsonRecord)JsonCodec.jsonCodec(JsonRecord.class).fromJson(logMessage);
        ((AbstractStringAssert)Assertions.assertThat((String)logMessage).as("Log lines should end with newline", new Object[0])).endsWith((CharSequence)"\n");
        Assert.assertEquals((Object)jsonRecord.getTimestamp().truncatedTo(ChronoUnit.NANOS), (Object)record.getInstant().truncatedTo(ChronoUnit.NANOS), (String)"Ensure timestamps between the original LogRecord and Json are equal to the nano");
        Assert.assertEquals((String)jsonRecord.getThread(), (String)Thread.currentThread().getName());
        Assert.assertEquals((Object)jsonRecord.getLevel(), (Object)Level.fromJulLevel((java.util.logging.Level)record.getLevel()));
        Assert.assertEquals((String)jsonRecord.getLoggerName(), (String)record.getLoggerName());
        Assert.assertEquals((String)jsonRecord.getMessage(), (String)record.getMessage());
        Assert.assertEquals(jsonMap.get("throwableClass"), (Object)testException.getClass().getName());
        Assert.assertEquals(jsonMap.get("throwableMessage"), (Object)testException.getMessage());
        Assert.assertEquals(jsonMap.get("stackTrace"), (Object)Throwables.getStackTraceAsString((Throwable)testException));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogContext() {
        SdkTracerProvider tracerProvider;
        InMemorySpanExporter exporter = InMemorySpanExporter.create();
        try (SdkTracerProvider sdkTracerProvider = tracerProvider = SdkTracerProvider.builder().addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)exporter)).build();){
            String logMessage;
            Span span = tracerProvider.get("test").spanBuilder("test-span").startSpan();
            String traceId = span.getSpanContext().getTraceId();
            String spanId = span.getSpanContext().getSpanId();
            String traceFlags = span.getSpanContext().getTraceFlags().asHex();
            Assertions.assertThat((boolean)TraceId.isValid((CharSequence)traceId)).isTrue();
            Assertions.assertThat((boolean)SpanId.isValid((CharSequence)spanId)).isTrue();
            Assertions.assertThat((String)traceFlags).isEqualTo("01");
            LogRecord record = new LogRecord(Level.DEBUG.toJulLevel(), "Test Log Message");
            try (Scope ignored = span.makeCurrent();){
                logMessage = new JsonFormatter((Map)ImmutableMap.of()).format(record);
            }
            finally {
                span.end();
            }
            Map jsonMap = (Map)JsonCodec.mapJsonCodec(String.class, Object.class).fromJson(logMessage);
            Assertions.assertThat(jsonMap.get("traceId")).isEqualTo((Object)traceId);
            Assertions.assertThat(jsonMap.get("spanId")).isEqualTo((Object)spanId);
            Assertions.assertThat(jsonMap.get("traceFlags")).isEqualTo((Object)traceFlags);
        }
    }

    @Test
    public void testLogAnnotations() {
        LogRecord record = new LogRecord(Level.DEBUG.toJulLevel(), "Test Log Message");
        ImmutableMap logAnnotations = ImmutableMap.of((Object)"foo", (Object)"apple", (Object)"bar", (Object)"banana");
        String logMessage = new JsonFormatter((Map)logAnnotations).format(record);
        Map jsonMap = (Map)JsonCodec.mapJsonCodec(String.class, Object.class).fromJson(logMessage);
        JsonRecord jsonRecord = (JsonRecord)JsonCodec.jsonCodec(JsonRecord.class).fromJson(logMessage);
        Assert.assertEquals((String)jsonRecord.getMessage(), (String)record.getMessage());
        ((MapAssert)Assertions.assertThat(jsonMap.get("annotations")).asInstanceOf(InstanceOfAssertFactories.map(String.class, String.class))).containsExactlyEntriesOf((Map)logAnnotations);
    }
}

