/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import com.google.common.net.HostAndPort;
import io.airlift.log.MessageOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import org.weakref.jmx.Managed;

public class SocketMessageOutput
implements MessageOutput {
    private static final int CONNECTION_TIMEOUT_MILLIS = 100;
    private static final int MAX_WRITE_ATTEMPTS_PER_MESSAGE = 5;
    private final InetSocketAddress socketAddress;
    private final AtomicLong failedConnections = new AtomicLong(0L);
    @GuardedBy(value="this")
    private Socket socket;
    @GuardedBy(value="this")
    private OutputStream currentOutputStream;

    SocketMessageOutput(HostAndPort hostAndPort) {
        Objects.requireNonNull(hostAndPort, "hostAndPort is null");
        this.socketAddress = new InetSocketAddress(hostAndPort.getHost(), hostAndPort.getPort());
    }

    @Override
    public synchronized void writeMessage(byte[] message) throws IOException {
        IOException lastException = null;
        boolean success = false;
        int connectionFailures = 0;
        for (int i = 0; i < 5; ++i) {
            if (this.socket == null || this.socket.isClosed() || this.currentOutputStream == null) {
                try {
                    this.socket = new Socket();
                    this.socket.connect(this.socketAddress, 100);
                    this.currentOutputStream = this.socket.getOutputStream();
                }
                catch (IOException e) {
                    this.socket.close();
                    this.socket = null;
                    this.currentOutputStream = null;
                    lastException = e;
                    ++connectionFailures;
                    continue;
                }
            }
            try {
                this.currentOutputStream.write(message);
                success = true;
                break;
            }
            catch (IOException e) {
                this.socket.close();
                this.socket = null;
                this.currentOutputStream = null;
                ++connectionFailures;
                lastException = e;
            }
        }
        if (connectionFailures > 0) {
            this.failedConnections.addAndGet(connectionFailures);
            if (!success) {
                throw new IOException("Exception caught connecting via socket to %s:%s. There were %s failures attempting to write the log message.".formatted(this.socketAddress.getHostName(), this.socketAddress.getPort(), connectionFailures), lastException);
            }
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.currentOutputStream != null) {
            this.currentOutputStream.flush();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        IOException exception = new IOException("Exception thrown attempting to close the output stream and socket.");
        if (this.currentOutputStream != null) {
            try {
                this.currentOutputStream.flush();
            }
            catch (IOException e) {
                exception.addSuppressed(e);
            }
            try {
                this.currentOutputStream.close();
            }
            catch (IOException e) {
                exception.addSuppressed(e);
            }
        }
        this.currentOutputStream = null;
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                exception.addSuppressed(e);
            }
        }
        this.socket = null;
        if (exception.getSuppressed().length > 0) {
            throw exception;
        }
    }

    @Managed
    public long getFailedConnections() {
        return this.failedConnections.get();
    }
}

