/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.log.BufferedHandler;
import io.airlift.log.Format;
import io.airlift.log.LegacyRollingFileHandler;
import io.airlift.log.LogFileName;
import io.airlift.log.RollingFileMessageOutput;
import io.airlift.units.DataSize;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(timeOut=300000L)
public class TestRollingFileMessageOutput {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicLogging() throws Exception {
        Path tempDir = Files.createTempDirectory("logging-test", new FileAttribute[0]);
        try {
            Path masterFile = tempDir.resolve("launcher.log");
            BufferedHandler handler = RollingFileMessageOutput.createRollingFileHandler((String)masterFile.toString(), (DataSize)new DataSize(1.0, DataSize.Unit.MEGABYTE), (DataSize)new DataSize(10.0, DataSize.Unit.MEGABYTE), (RollingFileMessageOutput.CompressionType)RollingFileMessageOutput.CompressionType.NONE, (Formatter)Format.TEXT.getFormatter());
            Assert.assertTrue((boolean)Files.exists(masterFile, new LinkOption[0]));
            Assert.assertTrue((boolean)Files.isSymbolicLink(masterFile));
            handler.publish(new LogRecord(Level.SEVERE, "apple"));
            List<String> lines = TestRollingFileMessageOutput.waitForExactLines(masterFile, 1);
            Assert.assertEquals((int)lines.size(), (int)1);
            Assert.assertEquals((long)lines.stream().filter(line -> line.contains("apple")).count(), (long)1L);
            handler.publish(new LogRecord(Level.SEVERE, "banana"));
            lines = TestRollingFileMessageOutput.waitForExactLines(masterFile, 2);
            Assert.assertEquals((int)lines.size(), (int)2);
            Assert.assertEquals((long)Files.readAllLines(masterFile, StandardCharsets.UTF_8).stream().filter(line -> line.contains("banana")).count(), (long)1L);
            handler.close();
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRollAndPrune() throws Exception {
        String message = Strings.padEnd((String)"", (int)99, (char)'x') + "\n";
        Path tempDir = Files.createTempDirectory("logging-test", new FileAttribute[0]);
        try {
            int i;
            Path masterFile = tempDir.resolve("launcher.log");
            BufferedHandler handler = RollingFileMessageOutput.createRollingFileHandler((String)masterFile.toString(), (DataSize)new DataSize((double)(message.length() * 5), DataSize.Unit.BYTE), (DataSize)new DataSize((double)(message.length() * 2 + message.length() * 5 + message.length() * 5), DataSize.Unit.BYTE), (RollingFileMessageOutput.CompressionType)RollingFileMessageOutput.CompressionType.NONE, (Formatter)Format.TEXT.getFormatter());
            handler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return record.getMessage();
                }
            });
            TestRollingFileMessageOutput.assertLogSizes(masterFile, handler, 0, message.length(), 1);
            for (i = 0; i < 5; ++i) {
                handler.publish(new LogRecord(Level.SEVERE, message));
                TestRollingFileMessageOutput.assertLogSizes(masterFile, handler, i + 1, message.length(), 1);
            }
            for (i = 0; i < 5; ++i) {
                handler.publish(new LogRecord(Level.SEVERE, message));
                TestRollingFileMessageOutput.assertLogSizes(masterFile, handler, i + 1, message.length(), 2);
            }
            for (i = 0; i < 2; ++i) {
                handler.publish(new LogRecord(Level.SEVERE, message));
                TestRollingFileMessageOutput.assertLogSizes(masterFile, handler, i + 1, message.length(), 3);
            }
            for (i = 0; i < 3; ++i) {
                handler.publish(new LogRecord(Level.SEVERE, message));
                TestRollingFileMessageOutput.assertLogSizes(masterFile, handler, i + 3, message.length(), 2);
            }
            for (i = 0; i < 2; ++i) {
                handler.publish(new LogRecord(Level.SEVERE, message));
                TestRollingFileMessageOutput.assertLogSizes(masterFile, handler, i + 1, message.length(), 3);
            }
            for (i = 0; i < 3; ++i) {
                handler.publish(new LogRecord(Level.SEVERE, message));
                TestRollingFileMessageOutput.assertLogSizes(masterFile, handler, i + 3, message.length(), 2);
            }
            handler.close();
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompression() throws Exception {
        String message = Strings.padEnd((String)"", (int)9, (char)'x') + "\n";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (GZIPOutputStream compressOut = new GZIPOutputStream(out);){
            for (int i = 0; i < 5; ++i) {
                compressOut.write(message.getBytes(StandardCharsets.UTF_8));
            }
            compressOut.flush();
        }
        int expectedCompressedSize = out.toByteArray().length;
        Assert.assertTrue((expectedCompressedSize < message.length() * 5 ? 1 : 0) != 0);
        Assert.assertTrue((expectedCompressedSize > message.length() ? 1 : 0) != 0);
        Path tempDir = Files.createTempDirectory("logging-test", new FileAttribute[0]);
        try {
            int i;
            Path masterFile = tempDir.resolve("launcher.log");
            BufferedHandler handler = RollingFileMessageOutput.createRollingFileHandler((String)masterFile.toString(), (DataSize)new DataSize((double)(message.length() * 5), DataSize.Unit.BYTE), (DataSize)new DataSize((double)(message.length() + message.length() * 5 + expectedCompressedSize), DataSize.Unit.BYTE), (RollingFileMessageOutput.CompressionType)RollingFileMessageOutput.CompressionType.GZIP, (Formatter)Format.TEXT.getFormatter());
            handler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return record.getMessage();
                }
            });
            TestRollingFileMessageOutput.assertLogSizes(masterFile, handler, 0, message.length(), 1);
            for (i = 0; i < 5; ++i) {
                handler.publish(new LogRecord(Level.SEVERE, message));
                TestRollingFileMessageOutput.assertLogSizes(masterFile, handler, i + 1, message.length(), 1);
            }
            handler.publish(new LogRecord(Level.SEVERE, message));
            TestRollingFileMessageOutput.assertCompression(masterFile, handler, message, 2, 5, expectedCompressedSize);
            for (i = 0; i < 4; ++i) {
                handler.publish(new LogRecord(Level.SEVERE, message));
            }
            TestRollingFileMessageOutput.assertCompression(masterFile, handler, message, 2, 5, expectedCompressedSize);
            handler.publish(new LogRecord(Level.SEVERE, message));
            TestRollingFileMessageOutput.assertCompression(masterFile, handler, message, 3, 5, expectedCompressedSize);
            for (i = 0; i < 4; ++i) {
                handler.publish(new LogRecord(Level.SEVERE, message));
            }
            TestRollingFileMessageOutput.assertLogSizes(masterFile, handler, 5, message.length(), 2);
            TestRollingFileMessageOutput.assertCompression(masterFile, handler, message, 2, 5, expectedCompressedSize);
            handler.close();
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClosedHandler() throws Exception {
        Path tempDir = Files.createTempDirectory("logging-test", new FileAttribute[0]);
        try {
            Path masterFile = tempDir.resolve("launcher.log");
            BufferedHandler handler = RollingFileMessageOutput.createRollingFileHandler((String)masterFile.toString(), (DataSize)new DataSize(1.0, DataSize.Unit.MEGABYTE), (DataSize)new DataSize(10.0, DataSize.Unit.MEGABYTE), (RollingFileMessageOutput.CompressionType)RollingFileMessageOutput.CompressionType.NONE, (Formatter)Format.TEXT.getFormatter());
            handler.publish(new LogRecord(Level.SEVERE, "apple"));
            handler.publish(new LogRecord(Level.SEVERE, "banana"));
            handler.close();
            handler.publish(new LogRecord(Level.SEVERE, "cherry"));
            List<String> lines = TestRollingFileMessageOutput.waitForExactLines(masterFile, 2);
            Assert.assertEquals((int)lines.size(), (int)2);
            Assert.assertEquals((long)Files.readAllLines(masterFile, StandardCharsets.UTF_8).stream().filter(line -> line.contains("apple") || line.contains("banana")).count(), (long)2L);
            handler.flush();
            handler.close();
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoggingInExistingDirectory() throws Exception {
        Path tempDir = Files.createTempDirectory("logging-test", new FileAttribute[0]);
        try {
            Path masterFile = tempDir.resolve("launcher.log");
            BufferedHandler handler = RollingFileMessageOutput.createRollingFileHandler((String)masterFile.toString(), (DataSize)new DataSize(1.0, DataSize.Unit.MEGABYTE), (DataSize)new DataSize(10.0, DataSize.Unit.MEGABYTE), (RollingFileMessageOutput.CompressionType)RollingFileMessageOutput.CompressionType.NONE, (Formatter)Format.TEXT.getFormatter());
            Path firstLogFile = Files.readSymbolicLink(masterFile);
            handler.publish(new LogRecord(Level.SEVERE, "apple"));
            handler.publish(new LogRecord(Level.SEVERE, "banana"));
            List<String> lines = TestRollingFileMessageOutput.waitForExactLines(masterFile, 2);
            Assert.assertEquals((int)lines.size(), (int)2);
            Assert.assertEquals((long)Files.readAllLines(masterFile, StandardCharsets.UTF_8).stream().filter(line -> line.contains("apple") || line.contains("banana")).count(), (long)2L);
            handler.close();
            handler = RollingFileMessageOutput.createRollingFileHandler((String)masterFile.toString(), (DataSize)new DataSize(1.0, DataSize.Unit.MEGABYTE), (DataSize)new DataSize(10.0, DataSize.Unit.MEGABYTE), (RollingFileMessageOutput.CompressionType)RollingFileMessageOutput.CompressionType.NONE, (Formatter)Format.TEXT.getFormatter());
            Assert.assertNotEquals((Object)Files.readSymbolicLink(masterFile), (Object)firstLogFile);
            handler.publish(new LogRecord(Level.SEVERE, "cherry"));
            lines = TestRollingFileMessageOutput.waitForExactLines(masterFile, 1);
            Assert.assertEquals((int)lines.size(), (int)1);
            Assert.assertEquals((long)lines.stream().filter(line -> line.contains("cherry")).count(), (long)1L);
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoggingInExistingLegacyDirectory() throws Exception {
        Path tempDir = Files.createTempDirectory("logging-test", new FileAttribute[0]);
        try {
            Path masterFile = tempDir.resolve("launcher.log");
            LegacyRollingFileHandler legacyHandler = new LegacyRollingFileHandler(masterFile.toString(), 10, new DataSize(1.0, DataSize.Unit.MEGABYTE).toBytes(), Format.TEXT);
            Assert.assertTrue((boolean)Files.isRegularFile(masterFile, new LinkOption[0]));
            legacyHandler.publish(new LogRecord(Level.SEVERE, "apple"));
            legacyHandler.publish(new LogRecord(Level.SEVERE, "banana"));
            List<String> lines = TestRollingFileMessageOutput.waitForExactLines(masterFile, 2);
            Assert.assertEquals((int)lines.size(), (int)2);
            Assert.assertEquals((long)Files.readAllLines(masterFile, StandardCharsets.UTF_8).stream().filter(line -> line.contains("apple") || line.contains("banana")).count(), (long)2L);
            legacyHandler.close();
            BufferedHandler newHandler = RollingFileMessageOutput.createRollingFileHandler((String)masterFile.toString(), (DataSize)new DataSize(1.0, DataSize.Unit.MEGABYTE), (DataSize)new DataSize(10.0, DataSize.Unit.MEGABYTE), (RollingFileMessageOutput.CompressionType)RollingFileMessageOutput.CompressionType.NONE, (Formatter)Format.TEXT.getFormatter());
            Assert.assertTrue((boolean)Files.isSymbolicLink(masterFile));
            Assert.assertEquals((int)((RollingFileMessageOutput)newHandler.getMessageOutput()).getFiles().size(), (int)2);
            newHandler.publish(new LogRecord(Level.SEVERE, "cherry"));
            newHandler.publish(new LogRecord(Level.SEVERE, "date"));
            lines = TestRollingFileMessageOutput.waitForExactLines(masterFile, 2);
            Assert.assertEquals((int)lines.size(), (int)2);
            Assert.assertEquals((long)lines.stream().filter(line -> line.contains("cherry") || line.contains("date")).count(), (long)2L);
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    private static void assertCompression(Path masterFile, BufferedHandler handler, String message, int expectedFileCount, int expectedLineCount, int expectedCompressedSize) throws Exception {
        Set<LogFileName> compressedFileNames = TestRollingFileMessageOutput.waitForCompression((RollingFileMessageOutput)handler.getMessageOutput(), expectedFileCount);
        Assert.assertEquals((int)compressedFileNames.size(), (int)(expectedFileCount - 1));
        for (LogFileName compressedFileName : compressedFileNames) {
            Path compressedFile = masterFile.resolveSibling(compressedFileName.getFileName());
            Assert.assertEquals((long)Files.size(compressedFile), (long)expectedCompressedSize);
            ImmutableList lines = new GzippedByteSource(MoreFiles.asByteSource((Path)compressedFile, (OpenOption[])new OpenOption[0])).asCharSource(StandardCharsets.UTF_8).readLines();
            Assert.assertEquals((int)lines.size(), (int)expectedLineCount);
            Assert.assertTrue((boolean)lines.stream().allMatch(message.trim()::equals));
        }
    }

    private static void assertLogSizes(Path masterFile, BufferedHandler handler, int expectedLines, int lineSize, int expectedFileCount) throws Exception {
        Set<LogFileName> files = TestRollingFileMessageOutput.waitForExactFiles((RollingFileMessageOutput)handler.getMessageOutput(), expectedFileCount);
        Assert.assertEquals((int)files.size(), (int)expectedFileCount);
        List<String> lines = TestRollingFileMessageOutput.waitForExactLines(masterFile, expectedLines);
        Assert.assertEquals((int)lines.size(), (int)expectedLines);
        Assert.assertEquals((long)Files.size(masterFile), (long)(expectedLines * lineSize));
    }

    private static List<String> waitForExactLines(Path masterFile, int exactCount) throws IOException, InterruptedException {
        List<String> lines;
        while ((lines = Files.readAllLines(masterFile, StandardCharsets.UTF_8)).size() != exactCount) {
            Thread.sleep(10L);
        }
        return lines;
    }

    private static Set<LogFileName> waitForExactFiles(RollingFileMessageOutput fileHandler, int exactCount) throws Exception {
        Set files;
        while ((files = fileHandler.getFiles()).size() != exactCount) {
            Thread.sleep(10L);
        }
        return files;
    }

    private static Set<LogFileName> waitForCompression(RollingFileMessageOutput fileHandler, int exactCount) throws Exception {
        Set compressedFiles;
        Set files;
        while ((files = fileHandler.getFiles()).size() != exactCount || (compressedFiles = (Set)files.stream().filter(LogFileName::isCompressed).collect(ImmutableSet.toImmutableSet())).size() != exactCount - 1) {
            Thread.sleep(10L);
        }
        return compressedFiles;
    }

    private static class GzippedByteSource
    extends ByteSource {
        private final ByteSource source;

        public GzippedByteSource(ByteSource gzippedSource) {
            this.source = gzippedSource;
        }

        public InputStream openStream() throws IOException {
            return new GZIPInputStream(this.source.openStream());
        }
    }
}

