/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.log.Format;
import io.airlift.log.LoggingConfiguration;
import io.airlift.log.RollingFileMessageOutput;
import io.airlift.units.DataSize;
import java.util.Map;
import org.testng.annotations.Test;

public class TestLoggingConfiguration {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((LoggingConfiguration)ConfigAssertions.recordDefaults(LoggingConfiguration.class)).setConsoleEnabled(true).setLogPath(null).setMaxSize(new DataSize(100.0, DataSize.Unit.MEGABYTE)).setMaxTotalSize(new DataSize(1.0, DataSize.Unit.GIGABYTE)).setCompression(RollingFileMessageOutput.CompressionType.GZIP).setMaxHistory(30).setLevelsFile(null).setFormat(Format.TEXT).setLegacyLoggerImplementationEnabled(false));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"log.enable-console", (Object)"false").put((Object)"log.path", (Object)"/tmp/log.log").put((Object)"log.max-size", (Object)"1kB").put((Object)"log.max-total-size", (Object)"33kB").put((Object)"log.compression", (Object)"NONE").put((Object)"log.max-history", (Object)"3").put((Object)"log.levels-file", (Object)"/tmp/levels.txt").put((Object)"log.format", (Object)"json").put((Object)"log.legacy-implementation.enabled", (Object)"true").build();
        LoggingConfiguration expected = new LoggingConfiguration().setConsoleEnabled(false).setLogPath("/tmp/log.log").setMaxSize(new DataSize(1.0, DataSize.Unit.KILOBYTE)).setMaxTotalSize(new DataSize(33.0, DataSize.Unit.KILOBYTE)).setCompression(RollingFileMessageOutput.CompressionType.NONE).setMaxHistory(3).setLevelsFile("/tmp/levels.txt").setFormat(Format.JSON).setLegacyLoggerImplementationEnabled(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

