/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import com.google.common.base.Throwables;
import io.airlift.json.JsonCodec;
import io.airlift.log.JsonFormatter;
import io.airlift.log.JsonRecord;
import io.airlift.log.Level;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.logging.LogRecord;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestJsonFormatter {
    @Test
    public void testMinimalJsonErrorLogLine() {
        JsonRecord original = new JsonRecord(Instant.now(), Level.DEBUG, "thread-0", "TestLogger", "Test Log Message", (Throwable)new Exception("Test Exception 1"));
        RuntimeException exception = new RuntimeException("Test Exception 2");
        String minimalJsonErrorLogLine = new JsonFormatter().minimalJsonErrorLogLine(original, (Exception)exception);
        ((AbstractStringAssert)Assertions.assertThat((String)minimalJsonErrorLogLine).as("Log lines should end with newline", new Object[0])).endsWith((CharSequence)"\n");
        Assert.assertEquals((Object)JsonCodec.jsonCodec(JsonRecord.class).fromJson(minimalJsonErrorLogLine), (Object)new JsonRecord(original.getTimestamp(), Level.ERROR, null, null, exception.getMessage(), null));
    }

    @Test
    public void testRoundTrip() {
        JsonRecord original = new JsonRecord(Instant.now(), Level.DEBUG, "thread-0", "TestLogger", "Test Log Message", (Throwable)new Exception("Test Exception 1"));
        Assert.assertEquals((Object)JsonCodec.jsonCodec(JsonRecord.class).fromJson(JsonCodec.jsonCodec(JsonRecord.class).toJson((Object)original)), (Object)new JsonRecord(original.getTimestamp(), original.getLevel(), original.getThread(), original.getLoggerName(), original.getMessage(), null));
    }

    @Test
    public void testLogFormatting() {
        RuntimeException testException = new RuntimeException("Test Exception");
        LogRecord record = new LogRecord(Level.DEBUG.toJulLevel(), "Test Log Message");
        record.setLoggerName("TestLogger");
        record.setThrown(testException);
        String logMessage = new JsonFormatter().format(record);
        Map jsonMap = (Map)JsonCodec.mapJsonCodec(String.class, String.class).fromJson(logMessage);
        JsonRecord jsonRecord = (JsonRecord)JsonCodec.jsonCodec(JsonRecord.class).fromJson(logMessage);
        ((AbstractStringAssert)Assertions.assertThat((String)logMessage).as("Log lines should end with newline", new Object[0])).endsWith((CharSequence)"\n");
        Assert.assertEquals((Object)jsonRecord.getTimestamp().truncatedTo(ChronoUnit.NANOS), (Object)record.getInstant().truncatedTo(ChronoUnit.NANOS), (String)"Ensure timestamps between the original LogRecord and Json are equal to the nano");
        Assert.assertEquals((String)jsonRecord.getThread(), (String)Thread.currentThread().getName());
        Assert.assertEquals((Object)jsonRecord.getLevel(), (Object)Level.fromJulLevel((java.util.logging.Level)record.getLevel()));
        Assert.assertEquals((String)jsonRecord.getLoggerName(), (String)record.getLoggerName());
        Assert.assertEquals((String)jsonRecord.getMessage(), (String)record.getMessage());
        Assert.assertEquals((String)((String)jsonMap.get("throwableClass")), (String)testException.getClass().getName());
        Assert.assertEquals((String)((String)jsonMap.get("throwableMessage")), (String)testException.getMessage());
        Assert.assertEquals((String)((String)jsonMap.get("stackTrace")), (String)Throwables.getStackTraceAsString((Throwable)testException));
    }
}

