/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import com.google.common.io.Files;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.airlift.log.LoggingConfiguration;
import io.airlift.testing.FileUtils;
import java.io.File;
import java.io.IOException;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestLogging {
    private File tempDir;

    @BeforeMethod
    public void setup() throws IOException {
        this.tempDir = this.createTempDir();
    }

    @AfterMethod
    public void tearDown() throws IOException {
        FileUtils.deleteRecursively((File)this.tempDir);
    }

    @Test
    public void testRecoverTempFiles() throws IOException {
        LoggingConfiguration configuration = new LoggingConfiguration();
        configuration.setLogPath(new File(this.tempDir, "launcher.log").getPath());
        File logFile1 = new File(this.tempDir, "test1.log");
        Files.touch((File)logFile1);
        File logFile2 = new File(this.tempDir, "test2.log");
        Files.touch((File)logFile2);
        File tempLogFile1 = new File(this.tempDir, "temp1.tmp");
        Files.touch((File)tempLogFile1);
        File tempLogFile2 = new File(this.tempDir, "temp2.tmp");
        Files.touch((File)tempLogFile2);
        Logging logging = Logging.initialize();
        logging.configure(configuration);
        Assert.assertTrue((boolean)logFile1.exists());
        Assert.assertTrue((boolean)logFile2.exists());
        Assert.assertFalse((boolean)tempLogFile1.exists());
        Assert.assertFalse((boolean)tempLogFile2.exists());
        Assert.assertTrue((boolean)new File(this.tempDir, "temp1.log").exists());
        Assert.assertTrue((boolean)new File(this.tempDir, "temp2.log").exists());
    }

    @Test
    public void testPropagatesLevels() throws Exception {
        Logging logging = Logging.initialize();
        Logger logger = Logger.get((String)"testPropagatesLevels");
        logging.setLevel("testPropagatesLevels", Logging.Level.ERROR);
        Assert.assertFalse((boolean)logger.isDebugEnabled());
        Assert.assertFalse((boolean)logger.isInfoEnabled());
        logging.setLevel("testPropagatesLevels", Logging.Level.WARN);
        Assert.assertFalse((boolean)logger.isDebugEnabled());
        Assert.assertFalse((boolean)logger.isInfoEnabled());
        logging.setLevel("testPropagatesLevels", Logging.Level.INFO);
        Assert.assertFalse((boolean)logger.isDebugEnabled());
        Assert.assertTrue((boolean)logger.isInfoEnabled());
        logging.setLevel("testPropagatesLevels", Logging.Level.DEBUG);
        Assert.assertTrue((boolean)logger.isDebugEnabled());
        Assert.assertTrue((boolean)logger.isInfoEnabled());
    }

    @Test
    public void testPropagatesLevelsHierarchical() throws Exception {
        Logging logging = Logging.initialize();
        Logger logger = Logger.get((String)"testPropagatesLevelsHierarchical.child");
        logging.setLevel("testPropagatesLevelsHierarchical", Logging.Level.ERROR);
        Assert.assertFalse((boolean)logger.isDebugEnabled());
        Assert.assertFalse((boolean)logger.isInfoEnabled());
        logging.setLevel("testPropagatesLevelsHierarchical", Logging.Level.WARN);
        Assert.assertFalse((boolean)logger.isDebugEnabled());
        Assert.assertFalse((boolean)logger.isInfoEnabled());
        logging.setLevel("testPropagatesLevelsHierarchical", Logging.Level.INFO);
        Assert.assertFalse((boolean)logger.isDebugEnabled());
        Assert.assertTrue((boolean)logger.isInfoEnabled());
        logging.setLevel("testPropagatesLevelsHierarchical", Logging.Level.DEBUG);
        Assert.assertTrue((boolean)logger.isDebugEnabled());
        Assert.assertTrue((boolean)logger.isInfoEnabled());
    }

    @Test
    public void testChildLevelOverridesParent() throws Exception {
        Logging logging = Logging.initialize();
        Logger logger = Logger.get((String)"testChildLevelOverridesParent.child");
        logging.setLevel("testChildLevelOverridesParent", Logging.Level.DEBUG);
        logging.setLevel("testChildLevelOverridesParent.child", Logging.Level.ERROR);
        Assert.assertFalse((boolean)logger.isDebugEnabled());
        Assert.assertFalse((boolean)logger.isInfoEnabled());
    }

    private File createTempDir() throws IOException {
        File dir = File.createTempFile("temp", "_dir");
        if (!dir.delete()) {
            throw new IOException("Could not delete temp file: " + dir.getAbsolutePath());
        }
        if (!dir.mkdirs()) {
            throw new IOException("Could not create temp dir: " + dir.getAbsolutePath());
        }
        return dir;
    }
}

