/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import io.airlift.log.LoggingMBean;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestLoggingMBean {
    private final LoggingMBean logging = new LoggingMBean();
    private String rootLevel;

    @BeforeMethod
    public void setRootLevel() {
        this.rootLevel = this.logging.getRootLevel();
        this.logging.setRootLevel("INFO");
    }

    @AfterMethod
    public void restoreRootLevel() {
        this.logging.setRootLevel(this.rootLevel);
    }

    @Test
    public void testGetAndSetRoot() {
        Assert.assertEquals((String)this.logging.getRootLevel(), (String)"INFO");
        this.logging.setRootLevel("WARN");
        Assert.assertEquals((String)this.logging.getRootLevel(), (String)"WARN");
        this.logging.setRootLevel("INFO");
        Assert.assertEquals((String)this.logging.getRootLevel(), (String)"INFO");
    }

    @Test
    public void testGetAndSetNonExisting() {
        Assert.assertEquals((String)this.logging.getRootLevel(), (String)"INFO");
        String name = "this.logger.does.not.exist.yet.Bogus";
        Assert.assertFalse((boolean)this.logging.getAllLevels().containsKey(name));
        Assert.assertEquals((String)this.logging.getLevel(name), (String)"INFO");
        this.logging.setLevel(name, "WARN");
        Assert.assertEquals((String)this.logging.getLevel(name), (String)"WARN");
        Assert.assertTrue((boolean)this.logging.getAllLevels().containsKey(name));
        Assert.assertEquals((String)this.logging.getRootLevel(), (String)"INFO");
    }

    @Test
    public void testSetInvalidLevel() {
        Assert.assertEquals((String)this.logging.getRootLevel(), (String)"INFO");
        this.logging.setRootLevel("FOO");
        Assert.assertEquals((String)this.logging.getRootLevel(), (String)"DEBUG");
    }
}

