/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.EncoderBase;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import io.airlift.log.StaticFormatter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

final class RollingFileHandler
extends Handler {
    private static final String TEMP_FILE_EXTENSION = ".tmp";
    private static final String LOG_FILE_EXTENSION = ".log";
    private final RollingFileAppender<String> fileAppender;

    public RollingFileHandler(String filename, int retainDays, long maxSizeInBytes) {
        this.setFormatter(new StaticFormatter());
        ContextBase context = new ContextBase();
        this.recoverTempFiles(filename);
        this.fileAppender = new RollingFileAppender();
        TimeBasedRollingPolicy rollingPolicy = new TimeBasedRollingPolicy();
        SizeAndTimeBasedFNATP triggeringPolicy = new SizeAndTimeBasedFNATP();
        rollingPolicy.setContext((Context)context);
        rollingPolicy.setFileNamePattern(filename + "-%d{yyyy-MM-dd}.%i.log.gz");
        rollingPolicy.setMaxHistory(retainDays);
        rollingPolicy.setTimeBasedFileNamingAndTriggeringPolicy((TimeBasedFileNamingAndTriggeringPolicy)triggeringPolicy);
        rollingPolicy.setParent(this.fileAppender);
        rollingPolicy.start();
        triggeringPolicy.setContext((Context)context);
        triggeringPolicy.setTimeBasedRollingPolicy(rollingPolicy);
        triggeringPolicy.setMaxFileSize(Long.toString(maxSizeInBytes));
        triggeringPolicy.start();
        this.fileAppender.setContext((Context)context);
        this.fileAppender.setFile(filename);
        this.fileAppender.setAppend(true);
        this.fileAppender.setEncoder((Encoder)new StringEncoder());
        this.fileAppender.setRollingPolicy((RollingPolicy)rollingPolicy);
        this.fileAppender.start();
    }

    @Override
    public void publish(LogRecord record) {
        String message;
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            message = this.getFormatter().format(record);
        }
        catch (Exception e) {
            this.reportError(null, e, 5);
            return;
        }
        try {
            this.fileAppender.doAppend((Object)message);
        }
        catch (Exception e) {
            this.reportError(null, e, 1);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        try {
            this.fileAppender.stop();
        }
        catch (Exception e) {
            this.reportError(null, e, 3);
        }
    }

    private void recoverTempFiles(String logPath) {
        File logPathFile = new File(logPath).getParentFile();
        File[] tempFiles = logPathFile.listFiles((dir, name) -> name.endsWith(TEMP_FILE_EXTENSION));
        if (tempFiles == null) {
            return;
        }
        for (File tempFile : tempFiles) {
            String newName = tempFile.getName().substring(0, tempFile.getName().length() - TEMP_FILE_EXTENSION.length());
            File newFile = new File(tempFile.getParent(), newName + LOG_FILE_EXTENSION);
            if (tempFile.renameTo(newFile)) continue;
            this.reportError(String.format("Could not rename temp file [%s] to [%s]", tempFile, newFile), null, 4);
        }
    }

    private final class StringEncoder
    extends EncoderBase<String> {
        private StringEncoder() {
        }

        public void doEncode(String event) throws IOException {
            this.outputStream.write(event.getBytes(StandardCharsets.UTF_8));
            this.outputStream.flush();
        }

        public void close() throws IOException {
            this.outputStream.flush();
        }
    }
}

