/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jmx;

import io.airlift.jmx.JmxAgent;
import io.airlift.jmx.JmxConfig;
import io.airlift.jmx.NetUtils;
import io.airlift.node.NodeInfo;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestJMXAgent {
    @Test
    public void testAuto() throws IOException {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        JmxAgent agent = new JmxAgent(server, new JmxConfig(), new NodeInfo("test"));
        agent.start();
        JMXConnector connector = JMXConnectorFactory.connect(agent.getURL());
        connector.connect();
        MBeanServerConnection connection = connector.getMBeanServerConnection();
        Assert.assertTrue((connection.getMBeanCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSpecificHost() throws IOException {
        String host = new NodeInfo("test").getInternalIp().getCanonicalHostName();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        JmxAgent agent = new JmxAgent(server, new JmxConfig().setHostname(host), new NodeInfo("test"));
        agent.start();
        JMXConnector connector = JMXConnectorFactory.connect(agent.getURL());
        connector.connect();
        MBeanServerConnection connection = connector.getMBeanServerConnection();
        Assert.assertTrue((connection.getMBeanCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSpecificHostAndPort() throws IOException {
        String host = new NodeInfo("test").getInternalIp().getCanonicalHostName();
        int port = NetUtils.findUnusedPort();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        JmxConfig config = new JmxConfig().setRmiRegistryPort(Integer.valueOf(port)).setHostname(host);
        JmxAgent agent = new JmxAgent(server, config, new NodeInfo("test"));
        agent.start();
        JMXConnector connector = JMXConnectorFactory.connect(agent.getURL());
        connector.connect();
        MBeanServerConnection connection = connector.getMBeanServerConnection();
        Assert.assertTrue((connection.getMBeanCount() > 0 ? 1 : 0) != 0);
    }
}

