/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jmx;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.discovery.client.DiscoveryBinder;
import io.airlift.discovery.client.ServiceAnnouncement;
import io.airlift.jmx.JmxAgent;
import io.airlift.jmx.JmxConfig;
import io.airlift.jmx.StackTraceMBean;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import org.weakref.jmx.guice.ExportBuilder;
import org.weakref.jmx.guice.MBeanModule;

public class JmxModule
implements Module {
    public void configure(Binder binder) {
        binder.requireExplicitBindings();
        binder.disableCircularProxies();
        binder.bind(MBeanServer.class).toInstance((Object)ManagementFactory.getPlatformMBeanServer());
        binder.bind(JmxAgent.class).in(Scopes.SINGLETON);
        ConfigurationModule.bindConfig((Binder)binder).to(JmxConfig.class);
        ExportBuilder builder = MBeanModule.newExporter((Binder)binder);
        builder.export(StackTraceMBean.class).withGeneratedName();
        binder.bind(StackTraceMBean.class).in(Scopes.SINGLETON);
        DiscoveryBinder.discoveryBinder((Binder)binder).bindServiceAnnouncement(JmxAnnouncementProvider.class);
    }

    static class JmxAnnouncementProvider
    implements Provider<ServiceAnnouncement> {
        private JmxAgent jmxAgent;

        JmxAnnouncementProvider() {
        }

        @Inject
        public void setJmxAgent(JmxAgent jmxAgent) {
            this.jmxAgent = jmxAgent;
        }

        public ServiceAnnouncement get() {
            return ServiceAnnouncement.serviceAnnouncement((String)"jmx").addProperty("jmx", this.jmxAgent.getURL().toString()).build();
        }
    }
}

