/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jmx;

import com.google.common.net.HostAndPort;
import io.airlift.jmx.JavaVersion;
import io.airlift.jmx.JmxAgent8;
import io.airlift.jmx.JmxAgent9;
import io.airlift.jmx.JmxConfig;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class TestJmxAgent {
    @Test
    public void testJava8Agent() throws Exception {
        if (JavaVersion.current().getMajor() > 8) {
            throw new SkipException("Incompatible Java version: " + JavaVersion.current());
        }
        HostAndPort address = JmxAgent8.getRunningAgentAddress(null, null);
        JmxAgent8 agent = new JmxAgent8(new JmxConfig().setRmiRegistryPort(Integer.valueOf(8012)));
        if (address == null) {
            address = JmxAgent8.getRunningAgentAddress(null, null);
            Assert.assertNotNull((Object)address);
        }
        JMXServiceURL url = agent.getUrl();
        Assert.assertEquals((String)url.toString(), (String)String.format("service:jmx:rmi:///jndi/rmi://%s:%s/jmxrmi", address.getHost(), address.getPort()));
        JMXConnector connector = JMXConnectorFactory.connect(url);
        connector.connect();
    }

    @Test
    public void testJava9Agent() throws Exception {
        if (JavaVersion.current().getMajor() < 9) {
            throw new SkipException("Incompatible Java version: " + JavaVersion.current());
        }
        JmxAgent9 agent = new JmxAgent9(new JmxConfig().setRmiRegistryPort(Integer.valueOf(8012)));
        JMXServiceURL url = agent.getUrl();
        Assertions.assertThat((String)url.toString()).matches((CharSequence)"service:jmx:rmi:///jndi/rmi://.*:\\d+/jmxrmi");
        JMXConnector connector = JMXConnectorFactory.connect(url);
        connector.connect();
    }
}

