/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jmx;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.google.common.net.MediaType;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StringResponseHandler;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.http.server.testing.TestingHttpServer;
import io.airlift.http.server.testing.TestingHttpServerModule;
import io.airlift.jaxrs.JaxrsModule;
import io.airlift.jmx.JmxHttpModule;
import io.airlift.json.JsonModule;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.node.testing.TestingNodeModule;
import io.airlift.testing.Assertions;
import io.airlift.testing.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestMBeanResource {
    public final MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    private LifeCycleManager lifeCycleManager;
    private TestingHttpServer server;
    private HttpClient client;

    @BeforeMethod
    public void setup() throws Exception {
        Bootstrap app = new Bootstrap(new Module[]{new TestingNodeModule(), new TestingHttpServerModule(), new JsonModule(), new JaxrsModule(), new JmxHttpModule(), new Module(){

            public void configure(Binder binder) {
                binder.bind(MBeanServer.class).toInstance((Object)TestMBeanResource.this.mbeanServer);
            }
        }});
        Injector injector = app.quiet().strictConfig().initialize();
        this.lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        this.server = (TestingHttpServer)injector.getInstance(TestingHttpServer.class);
        this.client = new JettyHttpClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterMethod
    public void teardown() throws Exception {
        try {
            if (this.lifeCycleManager != null) {
                this.lifeCycleManager.stop();
            }
        }
        finally {
            Closeables.closeQuietly((Closeable)this.client);
        }
    }

    @DataProvider(name="mbeanNames")
    public Iterator<Object[]> createMBeanNames() {
        List<String> names = this.getMBeanNames();
        ImmutableList.Builder data = ImmutableList.builder();
        for (String name : names) {
            data.add((Object)new Object[]{name});
        }
        return data.build().iterator();
    }

    @Test
    public void testGetHtmlPage() throws Exception {
        StringResponseHandler.StringResponse response = (StringResponseHandler.StringResponse)this.client.execute(Request.Builder.prepareGet().setUri(this.uriFor("/v1/jmx")).build(), (ResponseHandler)StringResponseHandler.createStringResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
        TestMBeanResource.assertContentType(response, MediaType.HTML_UTF_8);
        Assertions.assertContains((String)response.getBody(), (String)"<html>");
    }

    @Test
    public void testGetMBeans() throws Exception {
        this.assertMBeansResponse(this.jsonRequest(this.uriFor("/v1/jmx/mbean")));
    }

    @Test
    public void testGetMBeansJsonp() throws Exception {
        this.assertMBeansResponse(this.jsonpRequest(this.uriFor("/v1/jmx/mbean")));
    }

    private void assertMBeansResponse(JsonNode mbeans) {
        ArrayList<String> names = new ArrayList<String>();
        for (JsonNode mbean : mbeans) {
            JsonNode name = mbean.get("objectName");
            Assert.assertTrue((boolean)name.isTextual());
            names.add(name.asText());
        }
        Assert.assertTrue((boolean)names.contains("java.lang:type=Memory"));
        Assert.assertTrue((boolean)names.contains("java.lang:type=Runtime"));
        Assertions.assertEqualsIgnoreOrder(names, this.getMBeanNames());
    }

    @Test(dataProvider="mbeanNames")
    public void testGetMBean(String mbeanName) throws Exception {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.uriFor("/v1/jmx/mbean")).appendPath(mbeanName).build();
        JsonNode mbean = this.jsonRequest(uri);
        JsonNode name = mbean.get("objectName");
        Assert.assertTrue((boolean)name.isTextual());
        Assert.assertEquals((String)name.asText(), (String)mbeanName);
    }

    @Test(dataProvider="mbeanNames")
    public void testGetMBeanJsonp(String mbeanName) throws Exception {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.uriFor("/v1/jmx/mbean")).appendPath(mbeanName).build();
        JsonNode mbean = this.jsonpRequest(uri);
        JsonNode name = mbean.get("objectName");
        Assert.assertTrue((boolean)name.isTextual());
        Assert.assertEquals((String)name.asText(), (String)mbeanName);
    }

    private JsonNode jsonRequest(URI uri) throws IOException {
        Request request = Request.Builder.prepareGet().setUri(uri).build();
        StringResponseHandler.StringResponse response = (StringResponseHandler.StringResponse)this.client.execute(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)200, (String)response.getBody());
        TestMBeanResource.assertContentType(response, MediaType.JSON_UTF_8);
        return new ObjectMapperProvider().get().readTree(response.getBody());
    }

    private JsonNode jsonpRequest(URI uri) throws IOException {
        uri = HttpUriBuilder.uriBuilderFrom((URI)uri).addParameter("jsonp", new String[]{"test"}).build();
        Request request = Request.Builder.prepareGet().setUri(uri).build();
        StringResponseHandler.StringResponse response = (StringResponseHandler.StringResponse)this.client.execute(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)200, (String)response.getBody());
        TestMBeanResource.assertContentType(response, MediaType.JSON_UTF_8);
        String jsonp = response.getBody().trim();
        Assert.assertTrue((boolean)jsonp.startsWith("test("), (String)jsonp);
        Assert.assertTrue((boolean)jsonp.endsWith(")"), (String)jsonp);
        jsonp = jsonp.substring(5, jsonp.length() - 1);
        return new ObjectMapperProvider().get().readTree(jsonp);
    }

    private URI uriFor(String path) {
        return this.server.getBaseUrl().resolve(path);
    }

    private List<String> getMBeanNames() {
        ImmutableList.Builder list = ImmutableList.builder();
        for (ObjectName objectName : this.mbeanServer.queryNames(ObjectName.WILDCARD, null)) {
            list.add((Object)objectName.toString());
        }
        return list.build();
    }

    private static void assertContentType(StringResponseHandler.StringResponse response, MediaType type) {
        String contentType = response.getHeader("Content-Type");
        Assert.assertTrue((boolean)MediaType.parse((String)contentType).is(type.withoutParameters()), (String)contentType);
    }
}

