/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jmx;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import com.google.inject.Inject;
import io.airlift.jmx.MBeanRepresentation;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/v1/jmx/mbean")
public class MBeanResource {
    private final MBeanServer mbeanServer;
    private final ObjectMapper objectMapper;

    @Inject
    public MBeanResource(MBeanServer mbeanServer, ObjectMapper objectMapper) {
        this.mbeanServer = mbeanServer;
        this.objectMapper = objectMapper;
    }

    @GET
    @Produces(value={"application/json"})
    public List<MBeanRepresentation> getMBeans() throws JMException {
        ImmutableList.Builder mbeans = ImmutableList.builder();
        for (ObjectName objectName : this.mbeanServer.queryNames(new ObjectName("*:*"), null)) {
            mbeans.add((Object)new MBeanRepresentation(this.mbeanServer, objectName, this.objectMapper));
        }
        return mbeans.build();
    }

    @GET
    @Produces(value={"text/html"})
    public String getMBeansUi() throws Exception {
        String html = Resources.toString((URL)Resources.getResource(this.getClass(), (String)"mbeans.html"), (Charset)Charsets.UTF_8);
        return html;
    }

    @GET
    @Path(value="{objectName}")
    @Produces(value={"application/json"})
    public MBeanRepresentation getMBean(@PathParam(value="objectName") ObjectName objectName) throws JMException {
        Preconditions.checkNotNull((Object)objectName, (Object)"objectName is null");
        return new MBeanRepresentation(this.mbeanServer, objectName, this.objectMapper);
    }
}

