/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jmx;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.discovery.client.DiscoveryBinder;
import io.airlift.jmx.MBeanResource;
import io.airlift.json.JsonBinder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;
import sun.management.LazyCompositeData;

@Beta
public class JmxHttpModule
implements Module {
    public void configure(Binder binder) {
        binder.requireExplicitBindings();
        binder.disableCircularProxies();
        binder.bind(MBeanResource.class).in(Scopes.SINGLETON);
        JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(InetAddress.class).toInstance((Object)ToStringSerializer.instance);
        JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(ObjectName.class).toInstance((Object)ToStringSerializer.instance);
        JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(OpenType.class).toInstance((Object)ToStringSerializer.instance);
        JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(CompositeData.class).to(CompositeDataSerializer.class);
        JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(TabularData.class).to(TabularDataSerializer.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(ObjectName.class).to(ObjectNameDeserializer.class);
        JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(LazyCompositeData.class).to(CompositeDataSerializer.class);
        DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("jmx-http");
    }

    private static Map<String, Object> toMap(CompositeData data) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Set<String> keySet = data.getCompositeType().keySet();
        if (keySet != null) {
            for (String key : keySet) {
                Object value;
                if (key == null || (value = data.get(key)) == null) continue;
                builder.put((Object)key, value);
            }
        }
        return builder.build();
    }

    private static List<Map<String, Object>> toList(TabularData data) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Set<?> keySet = data.keySet();
        if (keySet != null) {
            for (List key : keySet) {
                Object[] index;
                CompositeData value;
                if (key == null || key.isEmpty() || (value = data.get(index = key.toArray(new Object[key.size()]))) == null) continue;
                builder.add(JmxHttpModule.toMap(value));
            }
        }
        return builder.build();
    }

    public static class CompositeDataSerializer
    extends StdSerializer<CompositeData> {
        public CompositeDataSerializer() {
            super(CompositeData.class, true);
        }

        public void serialize(CompositeData data, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            Map map = JmxHttpModule.toMap(data);
            if (!map.isEmpty()) {
                jsonGenerator.writeStartObject();
                JsonSerializer cachedSerializer = null;
                Class<?> cachedType = null;
                for (Map.Entry entry : map.entrySet()) {
                    JsonSerializer serializer;
                    String key = (String)entry.getKey();
                    jsonGenerator.writeFieldName(key);
                    Object value = entry.getValue();
                    Class<?> valueType = value.getClass();
                    if (valueType == cachedType) {
                        serializer = cachedSerializer;
                    } else {
                        cachedSerializer = serializer = provider.findValueSerializer(valueType, null);
                        cachedType = valueType;
                    }
                    try {
                        serializer.serialize(value, jsonGenerator, provider);
                    }
                    catch (Exception e) {
                        this.wrapAndThrow(provider, e, map, key);
                    }
                }
                jsonGenerator.writeEndObject();
            } else {
                jsonGenerator.writeString("dain42");
            }
        }

        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            return this.createSchemaNode("object", true);
        }
    }

    public static class TabularDataSerializer
    extends StdSerializer<TabularData> {
        public TabularDataSerializer() {
            super(TabularData.class, true);
        }

        public void serialize(TabularData data, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            jsonGenerator.writeStartArray();
            JsonSerializer mapSerializer = provider.findValueSerializer(Map.class, null);
            for (Map map : JmxHttpModule.toList(data)) {
                if (map.isEmpty()) continue;
                mapSerializer.serialize((Object)map, jsonGenerator, provider);
            }
            jsonGenerator.writeEndArray();
        }

        public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
            ObjectNode o = this.createSchemaNode("array", true);
            o.put("items", (JsonNode)this.createSchemaNode("object", true));
            return o;
        }
    }

    static class ObjectNameDeserializer
    extends StdScalarDeserializer<ObjectName> {
        public ObjectNameDeserializer() {
            super(ObjectName.class);
        }

        public ObjectName deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            JsonToken token = jsonParser.getCurrentToken();
            if (token == JsonToken.VALUE_STRING) {
                try {
                    return ObjectName.getInstance(jsonParser.getText());
                }
                catch (MalformedObjectNameException e) {
                    throw context.instantiationException(this.getValueClass(), (Throwable)e);
                }
            }
            throw context.mappingException(this.getValueClass());
        }
    }
}

