/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.event.client.http;

import com.google.common.io.CharStreams;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.discovery.client.HttpServiceSelector;
import io.airlift.discovery.client.testing.StaticHttpServiceSelector;
import io.airlift.event.client.EventTypeMetadata;
import io.airlift.event.client.FixedDummyEventClass;
import io.airlift.event.client.JsonEventWriter;
import io.airlift.event.client.ServiceUnavailableException;
import io.airlift.event.client.TestingUtils;
import io.airlift.event.client.http.HttpEventClient;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.node.NodeInfo;
import io.airlift.units.Duration;
import jakarta.servlet.Servlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestHttpEventClient {
    private DummyServlet servlet;
    private HttpEventClient client;
    private Server server;
    private URI baseUri;
    private HttpClient httpClient;

    @Test
    public void testFutureFailsWhenServiceUnavailable() {
        this.client = this.newEventClient(Collections.emptyList());
        Assertions.assertThatThrownBy(() -> this.client.post((Object[])new FixedDummyEventClass[]{new FixedDummyEventClass("host", Instant.now(), UUID.randomUUID(), 1, "foo")}).get()).hasCauseInstanceOf(ServiceUnavailableException.class).hasMessageContaining("Service type=[collector], pool=[general] is not available");
    }

    @Test
    public void testCallSucceedsWhenServiceUnavailable() {
        this.client = this.newEventClient(Collections.emptyList());
        this.client.post((Object[])new FixedDummyEventClass[]{new FixedDummyEventClass("host", Instant.now(), UUID.randomUUID(), 1, "foo")});
        Assertions.assertThat((String)this.servlet.lastPath).isNull();
        Assertions.assertThat((String)this.servlet.lastBody).isNull();
    }

    @Test
    public void testReceivesEvent() throws ExecutionException, InterruptedException, IOException {
        this.client = this.newEventClient(Arrays.asList(this.baseUri));
        this.client.post((Iterable)TestingUtils.getEvents()).get();
        Assertions.assertThat((String)this.servlet.lastPath).isEqualTo("/v2/event");
        Assertions.assertThat((String)this.servlet.lastBody).isEqualTo(TestingUtils.getNormalizedJson((String)"events.json"));
    }

    @Test
    public void loadTest() throws ExecutionException, InterruptedException, IOException {
        this.client = this.newEventClient(Arrays.asList(this.baseUri));
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        for (int i = 0; i < 100; ++i) {
            futures.add(this.client.post((Iterable)TestingUtils.getEvents()));
        }
        for (Future future : futures) {
            future.get();
        }
        Assertions.assertThat((String)this.servlet.lastPath).isEqualTo("/v2/event");
        Assertions.assertThat((String)this.servlet.lastBody).isEqualTo(TestingUtils.getNormalizedJson((String)"events.json"));
    }

    @BeforeEach
    public void setup() throws Exception {
        this.httpClient = new JettyHttpClient(new HttpClientConfig().setConnectTimeout(new Duration(10.0, TimeUnit.SECONDS)));
        this.servlet = new DummyServlet();
        this.server = this.createServer(this.servlet);
        this.server.start();
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        this.httpClient.close();
    }

    private HttpEventClient newEventClient(List<URI> uris) {
        StaticHttpServiceSelector selector = new StaticHttpServiceSelector("collector", "general", uris);
        Set eventTypes = EventTypeMetadata.getValidEventTypeMetaDataSet((Class[])new Class[]{FixedDummyEventClass.class});
        JsonEventWriter eventWriter = new JsonEventWriter(eventTypes);
        return new HttpEventClient((HttpServiceSelector)selector, eventWriter, new NodeInfo("test"), this.httpClient);
    }

    private Server createServer(DummyServlet servlet) throws Exception {
        int port;
        try (ServerSocket socket = new ServerSocket();){
            socket.bind(new InetSocketAddress(0));
            port = socket.getLocalPort();
        }
        this.baseUri = new URI("http", null, "127.0.0.1", port, null, null, null);
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setSendServerVersion(false);
        httpConfiguration.setSendXPoweredBy(false);
        this.server = new Server();
        ServerConnector httpConnector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfiguration)});
        httpConnector.setPort(port);
        httpConnector.setName("http");
        this.server.addConnector((Connector)httpConnector);
        ServletHolder servletHolder = new ServletHolder((Servlet)servlet);
        ServletContextHandler context = new ServletContextHandler(0);
        context.addServlet(servletHolder, "/*");
        ContextHandlerCollection handlers = new ContextHandlerCollection(new ContextHandler[0]);
        handlers.addHandler((Handler)context);
        this.server.setHandler((Handler)handlers);
        return this.server;
    }

    private static class DummyServlet
    extends HttpServlet {
        private volatile String lastPath;
        private volatile String lastBody;

        private DummyServlet() {
        }

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.lastPath = request.getPathInfo();
            this.lastBody = CharStreams.toString((Readable)new InputStreamReader((InputStream)request.getInputStream(), StandardCharsets.UTF_8));
        }
    }
}

