/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.concurrent;

import io.airlift.concurrent.ThreadLocalCache;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestThreadLocalCache {
    @Test
    public void testSanity() {
        AtomicInteger count = new AtomicInteger(0);
        ThreadLocalCache cache = new ThreadLocalCache(2, key -> key + count.getAndAdd(1));
        Assertions.assertThat((String)((String)cache.get((Object)"abc"))).isEqualTo("abc0");
        Assertions.assertThat((String)((String)cache.get((Object)"abc"))).isEqualTo("abc0");
        Assertions.assertThat((String)((String)cache.get((Object)"def"))).isEqualTo("def1");
        Assertions.assertThat((String)((String)cache.get((Object)"abc"))).isEqualTo("abc0");
        Assertions.assertThat((String)((String)cache.get((Object)"ghi"))).isEqualTo("ghi2");
        Assertions.assertThat((String)((String)cache.get((Object)"abc"))).isEqualTo("abc3");
    }

    @Test
    public void testDisallowsNulls() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new ThreadLocalCache(10, key -> null).get((Object)"foo")).isInstanceOf(NullPointerException.class)).hasMessageMatching("loader returned null value");
    }
}

