/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.concurrent;

import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.concurrent.DynamicSizeBoundQueue;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestDynamicSizeBoundQueue {
    private ListeningExecutorService executorService;

    @BeforeEach
    public void setUp() {
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
    }

    @AfterEach
    public void tearDown() {
        this.executorService.shutdownNow();
    }

    @Test
    public void testBasicOfferPoll() throws InterruptedException {
        DynamicSizeBoundQueue queue = new DynamicSizeBoundQueue(3L, String::length);
        Assertions.assertThat((long)queue.getMaxSize()).isEqualTo(3L);
        Assertions.assertThat((long)queue.getSize()).isZero();
        Assertions.assertThat((String)((String)queue.poll())).isNull();
        ((AbstractStringAssert)Assertions.assertThat((String)((String)queue.poll(1L, TimeUnit.MILLISECONDS))).as("Just use any short poll timeout to test the API", new Object[0])).isNull();
        Assertions.assertThat((boolean)queue.offer((Object)"a")).isTrue();
        Assertions.assertThat((long)queue.getMaxSize()).isEqualTo(3L);
        Assertions.assertThat((long)queue.getSize()).isEqualTo(1L);
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("a");
        ((AbstractStringAssert)Assertions.assertThat((String)((String)queue.poll())).as("No more elements", new Object[0])).isNull();
        Assertions.assertThat((long)queue.getSize()).isZero();
        Assertions.assertThat((boolean)queue.offer((Object)"a")).isTrue();
        Assertions.assertThat((boolean)queue.offer((Object)"bb")).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)queue.offer((Object)"c")).as("Queue already full", new Object[0])).isFalse();
        Assertions.assertThat((long)queue.getMaxSize()).isEqualTo(3L);
        Assertions.assertThat((long)queue.getSize()).isEqualTo(3L);
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("a");
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("bb");
        ((AbstractStringAssert)Assertions.assertThat((String)((String)queue.poll())).as("No more elements", new Object[0])).isNull();
        Assertions.assertThat((long)queue.getSize()).isZero();
        Assertions.assertThat((boolean)queue.offer((Object)"aa")).isTrue();
        Assertions.assertThat((boolean)queue.offer((Object)"bbb")).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)queue.offer((Object)"c")).as("Queue already over capacity", new Object[0])).isFalse();
        Assertions.assertThat((long)queue.getMaxSize()).isEqualTo(3L);
        Assertions.assertThat((long)queue.getSize()).isEqualTo(5L);
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("aa");
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("bbb");
        ((AbstractStringAssert)Assertions.assertThat((String)((String)queue.poll())).as("No more elements", new Object[0])).isNull();
        Assertions.assertThat((long)queue.getSize()).isZero();
    }

    @Test
    public void testOversizeElement() {
        DynamicSizeBoundQueue queue = new DynamicSizeBoundQueue(3L, String::length);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)queue.offer((Object)"aaaaa")).as("Queue always allows the insertion of an element as long as any space is available", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)queue.offer((Object)"b")).as("Queue already over capacity", new Object[0])).isFalse();
        Assertions.assertThat((long)queue.getSize()).isEqualTo(5L);
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("aaaaa");
        ((AbstractStringAssert)Assertions.assertThat((String)((String)queue.poll())).as("No more elements", new Object[0])).isNull();
        Assertions.assertThat((long)queue.getSize()).isZero();
    }

    @Test
    public void testOfferSizeOverflow() {
        DynamicSizeBoundQueue queue = new DynamicSizeBoundQueue(Long.MAX_VALUE, element -> element);
        Assertions.assertThat((boolean)queue.offer((Object)0x7FFFFFFFFFFFFFFEL)).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)queue.offer((Object)2L)).as("Element of size 2 should be rejected due to size numeric overflow", new Object[0])).isFalse();
        ((AbstractLongAssert)Assertions.assertThat((long)queue.getSize()).as("Size should remain unchanged", new Object[0])).isEqualTo(0x7FFFFFFFFFFFFFFEL);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)queue.offer((Object)Long.MAX_VALUE)).as("Element of size Long.MAX_VALUE should be rejected due to size numeric overflow", new Object[0])).isFalse();
        ((AbstractLongAssert)Assertions.assertThat((long)queue.getSize()).as("Size should remain unchanged", new Object[0])).isEqualTo(0x7FFFFFFFFFFFFFFEL);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)queue.offer((Object)1L)).as("Should be able to fill capacity up to Long.MAX_VALUE", new Object[0])).isTrue();
        ((AbstractLongAssert)Assertions.assertThat((long)queue.getSize()).as("Size should be at capacity", new Object[0])).isEqualTo(Long.MAX_VALUE);
        Assertions.assertThat((Long)((Long)queue.poll())).isEqualTo(0x7FFFFFFFFFFFFFFEL);
        Assertions.assertThat((Long)((Long)queue.poll())).isEqualTo(1L);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)queue.offer((Object)Long.MAX_VALUE)).as("Element of size Long.MAX_VALUE should be accepted for an empty queue", new Object[0])).isTrue();
        Assertions.assertThat((long)queue.getSize()).isEqualTo(Long.MAX_VALUE);
    }

    @Test
    public void testForcePutSizeOverflow() {
        DynamicSizeBoundQueue queue = new DynamicSizeBoundQueue(Long.MAX_VALUE, element -> element);
        Assertions.assertThat((boolean)queue.offer((Object)0x7FFFFFFFFFFFFFFEL)).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> queue.forcePut((Object)2L)).as("Element of size 2 should be rejected due to size numeric overflow", new Object[0])).isInstanceOf(IllegalStateException.class);
        ((AbstractLongAssert)Assertions.assertThat((long)queue.getSize()).as("Size should remain unchanged", new Object[0])).isEqualTo(0x7FFFFFFFFFFFFFFEL);
    }

    @Test
    public void testZeroSizeElement() {
        DynamicSizeBoundQueue queue = new DynamicSizeBoundQueue(1L, String::length);
        Assertions.assertThatThrownBy(() -> queue.offer((Object)"")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> queue.offer((Object)"", 10L, TimeUnit.SECONDS)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> queue.offerWithBackoff((Object)"")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> queue.put((Object)"")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> queue.forcePut((Object)"")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThat((long)queue.getSize()).isZero();
    }

    @Test
    public void testNegativeElementSizes() {
        DynamicSizeBoundQueue queue = new DynamicSizeBoundQueue(1L, ignored -> -1L);
        Assertions.assertThatThrownBy(() -> queue.offer((Object)"a")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> queue.offer((Object)"", 10L, TimeUnit.SECONDS)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> queue.offerWithBackoff((Object)"a")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> queue.put((Object)"a")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> queue.forcePut((Object)"a")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThat((long)queue.getSize()).isZero();
    }

    @Test
    public void testUnstableElementSize() {
        AtomicLong elementSizeToReport = new AtomicLong();
        DynamicSizeBoundQueue queue = new DynamicSizeBoundQueue(3L, ignored -> elementSizeToReport.get());
        elementSizeToReport.set(1L);
        Assertions.assertThat((boolean)queue.offer((Object)"a")).isTrue();
        Assertions.assertThat((long)queue.getSize()).isEqualTo(1L);
        elementSizeToReport.set(100L);
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("a");
        ((AbstractLongAssert)Assertions.assertThat((long)queue.getSize()).as("Even though the element size reported a new value, the original element size is respected", new Object[0])).isZero();
        elementSizeToReport.set(1L);
        Assertions.assertThat((boolean)queue.offer((Object)"b")).isTrue();
        Assertions.assertThat((long)queue.getSize()).isEqualTo(1L);
        elementSizeToReport.set(10L);
        Assertions.assertThat((boolean)queue.offer((Object)"c")).isTrue();
        Assertions.assertThat((long)queue.getSize()).isEqualTo(11L);
        elementSizeToReport.set(5L);
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("b");
        ((AbstractLongAssert)Assertions.assertThat((long)queue.getSize()).as("Even though the element size reported a new value, the original element size is respected", new Object[0])).isEqualTo(10L);
        elementSizeToReport.set(-1L);
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("c");
        ((AbstractLongAssert)Assertions.assertThat((long)queue.getSize()).as("Even though the element size reported a new negative value, the original element size is respected", new Object[0])).isZero();
    }

    @Test
    public void testNullElement() {
        DynamicSizeBoundQueue queue = new DynamicSizeBoundQueue(1L, value -> 1L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> queue.offer(null)).as("Queue does not permit null elements, even if the element size function does", new Object[0])).isInstanceOf(NullPointerException.class);
        ((AbstractLongAssert)Assertions.assertThat((long)queue.getSize()).as("Queue size should not be changed after failing on a null element", new Object[0])).isZero();
    }

    @Test
    public void testBlockingOffer() throws ExecutionException, InterruptedException, TimeoutException {
        final CountDownLatch awaitDequeueLatch = new CountDownLatch(1);
        DynamicSizeBoundQueue<String> queue = new DynamicSizeBoundQueue<String>(this, 3L, String::length){

            void preDequeueAwaitHook() {
                awaitDequeueLatch.countDown();
            }
        };
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)queue.offer((Object)"aaa")).as("Fill the queue", new Object[0])).isTrue();
        ListenableFuture offerFuture = this.executorService.submit(() -> TestDynamicSizeBoundQueue.lambda$testBlockingOffer$17((DynamicSizeBoundQueue)queue));
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)awaitDequeueLatch, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        Assertions.assertThat((boolean)offerFuture.isDone()).isFalse();
        ((AbstractStringAssert)Assertions.assertThat((String)((String)queue.poll())).as("Create space in the queue", new Object[0])).isEqualTo("aaa");
        ((AbstractBooleanAssert)Assertions.assertThat((Boolean)((Boolean)offerFuture.get(10L, TimeUnit.SECONDS))).as("Offer should complete quickly once space becomes available", new Object[0])).isTrue();
        ((AbstractStringAssert)Assertions.assertThat((String)((String)queue.poll())).as("Should be able to extract the new element from the queue", new Object[0])).isEqualTo("b");
    }

    @Test
    public void testBlockingOfferTimeout() throws ExecutionException, InterruptedException, TimeoutException {
        DynamicSizeBoundQueue queue = new DynamicSizeBoundQueue(3L, String::length);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)queue.offer((Object)"aaa")).as("Fill the queue", new Object[0])).isTrue();
        ListenableFuture offerFuture = this.executorService.submit(() -> queue.offer((Object)"b", 10L, TimeUnit.MILLISECONDS));
        ((AbstractBooleanAssert)Assertions.assertThat((Boolean)((Boolean)offerFuture.get(10L, TimeUnit.SECONDS))).as("Offer should timeout", new Object[0])).isFalse();
        ((AbstractLongAssert)Assertions.assertThat((long)queue.getSize()).as("Queue size should remain the same", new Object[0])).isEqualTo(3L);
    }

    @Test
    public void testPut() throws ExecutionException, InterruptedException, TimeoutException {
        final CountDownLatch awaitDequeueLatch = new CountDownLatch(1);
        DynamicSizeBoundQueue<String> queue = new DynamicSizeBoundQueue<String>(this, 3L, String::length){

            void preDequeueAwaitHook() {
                awaitDequeueLatch.countDown();
            }
        };
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)queue.offer((Object)"aaa")).as("Fill the queue", new Object[0])).isTrue();
        ListenableFuture putFuture = this.executorService.submit(() -> TestDynamicSizeBoundQueue.lambda$testPut$19((DynamicSizeBoundQueue)queue));
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)awaitDequeueLatch, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        Assertions.assertThat((boolean)putFuture.isDone()).isFalse();
        ((AbstractStringAssert)Assertions.assertThat((String)((String)queue.poll())).as("Create space in the queue", new Object[0])).isEqualTo("aaa");
        putFuture.get(10L, TimeUnit.SECONDS);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)queue.poll())).as("Should be able to extract the new element from the queue", new Object[0])).isEqualTo("b");
    }

    @Test
    public void testOfferWithBackoff() {
        DynamicSizeBoundQueue queue = new DynamicSizeBoundQueue(3L, String::length);
        for (int i = 0; i < 3; ++i) {
            ((OptionalAssert)Assertions.assertThat((Optional)queue.offerWithBackoff((Object)"a")).as("No backoff returned while space exists", new Object[0])).isEmpty();
        }
        ((AbstractLongAssert)Assertions.assertThat((long)queue.getSize()).as("Queue is at capacity", new Object[0])).isEqualTo(queue.getMaxSize());
        Optional backoffResult1 = queue.offerWithBackoff((Object)"b");
        ((OptionalAssert)Assertions.assertThat((Optional)backoffResult1).as("Queue should provide a backoff future when at capacity", new Object[0])).isPresent();
        Assertions.assertThat((Future)((Future)backoffResult1.get())).isNotDone();
        Optional backoffResult2 = queue.offerWithBackoff((Object)"c");
        ((OptionalAssert)Assertions.assertThat((Optional)backoffResult2).as("Queue should provide a backoff future when at capacity", new Object[0])).isPresent();
        Assertions.assertThat((Future)((Future)backoffResult2.get())).isNotDone();
        ((AbstractStringAssert)Assertions.assertThat((String)((String)queue.poll())).as("Dequeue an element to make some space", new Object[0])).isEqualTo("a");
        ((AbstractLongAssert)Assertions.assertThat((long)queue.getSize()).as("Space is now available", new Object[0])).isLessThan(queue.getMaxSize());
        Assertions.assertThat((Future)((Future)backoffResult1.get())).isDone();
        Assertions.assertThat((Future)((Future)backoffResult2.get())).isDone();
    }

    @Test
    public void testBlockingPoll() throws ExecutionException, InterruptedException, TimeoutException {
        final CountDownLatch awaitEnqueueLatch = new CountDownLatch(1);
        DynamicSizeBoundQueue<String> queue = new DynamicSizeBoundQueue<String>(this, 3L, String::length){

            void preEnqueueAwaitHook() {
                awaitEnqueueLatch.countDown();
            }
        };
        ListenableFuture pollFuture = this.executorService.submit(() -> TestDynamicSizeBoundQueue.lambda$testBlockingPoll$20((DynamicSizeBoundQueue)queue));
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)awaitEnqueueLatch, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        Assertions.assertThat((boolean)pollFuture.isDone()).isFalse();
        queue.offer((Object)"a");
        ((AbstractStringAssert)Assertions.assertThat((String)((String)pollFuture.get(10L, TimeUnit.SECONDS))).as("Should be able to extract new element as soon as it is added", new Object[0])).isEqualTo("a");
    }

    @Test
    public void testBlockingPollTimeout() throws ExecutionException, InterruptedException, TimeoutException {
        DynamicSizeBoundQueue queue = new DynamicSizeBoundQueue(3L, String::length);
        ListenableFuture pollFuture = this.executorService.submit(() -> (String)queue.poll(10L, TimeUnit.MILLISECONDS));
        ((AbstractStringAssert)Assertions.assertThat((String)((String)pollFuture.get(10L, TimeUnit.SECONDS))).as("Should timeout awaiting a new element", new Object[0])).isNull();
    }

    @Test
    public void testTake() throws ExecutionException, InterruptedException, TimeoutException {
        final CountDownLatch awaitEnqueueLatch = new CountDownLatch(1);
        DynamicSizeBoundQueue<String> queue = new DynamicSizeBoundQueue<String>(this, 3L, String::length){

            void preEnqueueAwaitHook() {
                awaitEnqueueLatch.countDown();
            }
        };
        ListenableFuture takeFuture = this.executorService.submit(() -> TestDynamicSizeBoundQueue.lambda$testTake$22((DynamicSizeBoundQueue)queue));
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)awaitEnqueueLatch, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        Assertions.assertThat((boolean)takeFuture.isDone()).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)queue.offer((Object)"a")).as("Insert new element", new Object[0])).isTrue();
        ((AbstractStringAssert)Assertions.assertThat((String)((String)takeFuture.get(10L, TimeUnit.SECONDS))).as("Take should return quickly once a new element becomes available", new Object[0])).isEqualTo("a");
    }

    @Test
    public void testConcurrency() throws ExecutionException, InterruptedException, TimeoutException {
        DynamicSizeBoundQueue queue = new DynamicSizeBoundQueue(3L, String::length);
        for (int i = 0; i < 10; ++i) {
            this.executorService.execute(() -> {
                int offered = 0;
                while (offered < 200) {
                    if (!queue.offer((Object)"a")) continue;
                    ++offered;
                }
            });
        }
        int spinLoopSubmissions = 2000;
        for (int i = 0; i < 10; ++i) {
            this.executorService.execute(() -> {
                try {
                    int offered = 0;
                    while (offered < 200) {
                        if (!queue.offer((Object)"bb", 100L, TimeUnit.MILLISECONDS)) continue;
                        ++offered;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    Assertions.fail((String)"Interrupted");
                }
            });
        }
        int blockingOfferSubmissions = 2000;
        for (int i = 0; i < 10; ++i) {
            this.executorService.execute(() -> {
                for (int j = 0; j < 200; ++j) {
                    try {
                        queue.put((Object)"ccc");
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        Assertions.fail((String)"Interrupted");
                    }
                }
            });
        }
        int blockingPutSubmissions = 2000;
        for (int i = 0; i < 10; ++i) {
            this.executorService.execute(() -> {
                for (int j = 0; j < 200; ++j) {
                    queue.forcePut((Object)"d");
                }
            });
        }
        int forcePutSubmissions = 2000;
        for (int i = 0; i < 10; ++i) {
            this.executorService.execute(() -> {
                for (int j = 0; j < 200; ++j) {
                    Optional backoffFuture = queue.offerWithBackoff((Object)"ee");
                    while (backoffFuture.isPresent()) {
                        Futures.getUnchecked((Future)((Future)backoffFuture.get()));
                        backoffFuture = queue.offerWithBackoff((Object)"ee");
                    }
                }
            });
        }
        int backoffFutureSubmissions = 2000;
        int totalSubmissions = spinLoopSubmissions + blockingOfferSubmissions + blockingPutSubmissions + forcePutSubmissions + backoffFutureSubmissions;
        ArrayList<ListenableFuture> pollFutures = new ArrayList<ListenableFuture>();
        ConcurrentHashMultiset dequeued = ConcurrentHashMultiset.create();
        for (int i = 0; i < 10; ++i) {
            pollFutures.add(this.executorService.submit(() -> {
                try {
                    while (dequeued.size() < totalSubmissions) {
                        Optional.ofNullable((String)queue.poll(1L, TimeUnit.MILLISECONDS)).ifPresent(x$0 -> dequeued.add(x$0));
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    Assertions.fail((String)"Interrupted");
                }
            }));
        }
        Futures.allAsList(pollFutures).get(10L, TimeUnit.SECONDS);
        ((AbstractLongAssert)Assertions.assertThat((long)queue.getSize()).as("Queue should be empty after pulling everything out", new Object[0])).isZero();
        Assertions.assertThat((int)dequeued.size()).isEqualTo(totalSubmissions);
        Assertions.assertThat((int)dequeued.count((Object)"a")).isEqualTo(spinLoopSubmissions);
        Assertions.assertThat((int)dequeued.count((Object)"bb")).isEqualTo(blockingOfferSubmissions);
        Assertions.assertThat((int)dequeued.count((Object)"ccc")).isEqualTo(blockingPutSubmissions);
        Assertions.assertThat((int)dequeued.count((Object)"d")).isEqualTo(forcePutSubmissions);
        Assertions.assertThat((int)dequeued.count((Object)"ee")).isEqualTo(backoffFutureSubmissions);
    }

    private static /* synthetic */ String lambda$testTake$22(DynamicSizeBoundQueue queue) throws Exception {
        try {
            return (String)queue.take();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static /* synthetic */ String lambda$testBlockingPoll$20(DynamicSizeBoundQueue queue) throws Exception {
        return (String)queue.poll(10L, TimeUnit.SECONDS);
    }

    private static /* synthetic */ void lambda$testPut$19(DynamicSizeBoundQueue queue) {
        try {
            queue.put((Object)"b");
        }
        catch (InterruptedException e) {
            Assertions.fail((String)"Interrupted");
        }
    }

    private static /* synthetic */ Boolean lambda$testBlockingOffer$17(DynamicSizeBoundQueue queue) throws Exception {
        return queue.offer((Object)"b", 10L, TimeUnit.SECONDS);
    }
}

