/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.concurrent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import javax.annotation.Nullable;

public final class ExtendedSettableFuture<V>
extends AbstractFuture<V> {
    public static <V> ExtendedSettableFuture<V> create() {
        return new ExtendedSettableFuture<V>();
    }

    private ExtendedSettableFuture() {
    }

    public boolean set(@Nullable V value) {
        return super.set(value);
    }

    public boolean setException(Throwable throwable) {
        return super.setException(throwable);
    }

    public void setAsync(ListenableFuture<? extends V> delegate) {
        Futures.addCallback(delegate, (FutureCallback)new FutureCallback<V>(){

            public void onSuccess(@Nullable V result) {
                ExtendedSettableFuture.this.set(result);
            }

            public void onFailure(Throwable t) {
                ExtendedSettableFuture.this.setException(t);
            }
        });
        super.addListener(() -> {
            if (super.isCancelled()) {
                delegate.cancel(super.wasInterrupted());
            }
        }, MoreExecutors.directExecutor());
    }

    @VisibleForTesting
    boolean checkWasInterrupted() {
        return super.wasInterrupted();
    }
}

