/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.concurrent;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.testing.Assertions;
import io.airlift.units.Duration;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestMoreFutures {
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"test-%s"));

    @AfterClass
    public void tearDown() {
        this.executorService.shutdownNow();
    }

    @Test
    public void testModifyUnmodifiableFuture() throws Exception {
        CompletableFuture future = new CompletableFuture();
        CompletableFuture unmodifiableFuture = MoreFutures.unmodifiableFuture(future);
        TestMoreFutures.assertFailure(() -> unmodifiableFuture.complete("fail"), UnsupportedOperationException.class::isInstance);
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertFalse((boolean)unmodifiableFuture.isDone());
        TestMoreFutures.assertFailure(() -> unmodifiableFuture.completeExceptionally(new IOException()), UnsupportedOperationException.class::isInstance);
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertFalse((boolean)unmodifiableFuture.isDone());
        TestMoreFutures.assertFailure(() -> unmodifiableFuture.obtrudeValue("fail"), UnsupportedOperationException.class::isInstance);
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertFalse((boolean)unmodifiableFuture.isDone());
        TestMoreFutures.assertFailure(() -> unmodifiableFuture.obtrudeException(new IOException()), UnsupportedOperationException.class::isInstance);
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertFalse((boolean)unmodifiableFuture.isDone());
        Assert.assertFalse((boolean)unmodifiableFuture.cancel(false));
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertFalse((boolean)unmodifiableFuture.isDone());
        Assert.assertFalse((boolean)unmodifiableFuture.cancel(true));
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertFalse((boolean)unmodifiableFuture.isDone());
        Assert.assertFalse((boolean)unmodifiableFuture.completeExceptionally(new CancellationException()));
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertFalse((boolean)unmodifiableFuture.isDone());
    }

    @Test
    public void testModifyCancelableUnmodifiableFuture() throws Exception {
        CompletableFuture future = new CompletableFuture();
        CompletableFuture unmodifiableFuture = MoreFutures.unmodifiableFuture(future, (boolean)true);
        TestMoreFutures.assertFailure(() -> unmodifiableFuture.complete("fail"), UnsupportedOperationException.class::isInstance);
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertFalse((boolean)unmodifiableFuture.isDone());
        TestMoreFutures.assertFailure(() -> unmodifiableFuture.completeExceptionally(new IOException()), UnsupportedOperationException.class::isInstance);
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertFalse((boolean)unmodifiableFuture.isDone());
        TestMoreFutures.assertFailure(() -> unmodifiableFuture.obtrudeValue("fail"), UnsupportedOperationException.class::isInstance);
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertFalse((boolean)unmodifiableFuture.isDone());
        TestMoreFutures.assertFailure(() -> unmodifiableFuture.obtrudeException(new IOException()), UnsupportedOperationException.class::isInstance);
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertFalse((boolean)unmodifiableFuture.isDone());
    }

    @Test
    public void testUnmodifiableFutureCancelPropagation() throws Exception {
        CompletableFuture future = new CompletableFuture();
        CompletableFuture unmodifiableFuture = MoreFutures.unmodifiableFuture(future, (boolean)true);
        Assert.assertTrue((boolean)unmodifiableFuture.cancel(false));
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertTrue((boolean)future.isCancelled());
        Assert.assertTrue((boolean)unmodifiableFuture.isDone());
        Assert.assertTrue((boolean)unmodifiableFuture.isCancelled());
        future = new CompletableFuture();
        unmodifiableFuture = MoreFutures.unmodifiableFuture(future, (boolean)true);
        Assert.assertTrue((boolean)unmodifiableFuture.cancel(true));
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertTrue((boolean)future.isCancelled());
        Assert.assertTrue((boolean)unmodifiableFuture.isDone());
        Assert.assertTrue((boolean)unmodifiableFuture.isCancelled());
        future = new CompletableFuture();
        unmodifiableFuture = MoreFutures.unmodifiableFuture(future, (boolean)true);
        Assert.assertTrue((boolean)unmodifiableFuture.completeExceptionally(new CancellationException()));
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertTrue((boolean)future.isCancelled());
        Assert.assertTrue((boolean)unmodifiableFuture.isDone());
        Assert.assertTrue((boolean)unmodifiableFuture.isCancelled());
    }

    @Test
    public void testCompleteUnmodifiableFuture() throws Exception {
        CompletableFuture<String> future = new CompletableFuture<String>();
        CompletableFuture unmodifiableFuture = MoreFutures.unmodifiableFuture(future);
        Assert.assertTrue((boolean)future.complete("done"));
        Assert.assertEquals((String)future.getNow(null), (String)"done");
        Assert.assertTrue((boolean)unmodifiableFuture.isDone());
        Assert.assertEquals((String)unmodifiableFuture.getNow(null), (String)"done");
    }

    @Test
    public void testCompleteExceptionallyUnmodifiableFuture() throws Exception {
        CompletableFuture future = new CompletableFuture();
        CompletableFuture unmodifiableFuture = MoreFutures.unmodifiableFuture(future);
        Assert.assertTrue((boolean)future.completeExceptionally(new SQLException("foo")));
        TestMoreFutures.assertFailure(() -> {
            String cfr_ignored_0 = (String)MoreFutures.getFutureValue((Future)future, SQLException.class);
        }, e -> {
            Assertions.assertInstanceOf((Object)e, SQLException.class);
            Assert.assertEquals((String)e.getMessage(), (String)"foo");
        });
        Assert.assertTrue((boolean)unmodifiableFuture.isDone());
        TestMoreFutures.assertFailure(() -> {
            String cfr_ignored_0 = (String)MoreFutures.getFutureValue((Future)unmodifiableFuture, SQLException.class);
        }, e -> {
            Assertions.assertInstanceOf((Object)e, SQLException.class);
            Assert.assertEquals((String)e.getMessage(), (String)"foo");
        });
    }

    @Test
    public void testAlreadyCompleteUnmodifiableFuture() throws Exception {
        CompletableFuture<String> future = CompletableFuture.completedFuture("done");
        CompletableFuture unmodifiableFuture = MoreFutures.unmodifiableFuture(future);
        Assert.assertEquals((String)future.getNow(null), (String)"done");
        Assert.assertTrue((boolean)unmodifiableFuture.isDone());
        Assert.assertEquals((String)unmodifiableFuture.getNow(null), (String)"done");
    }

    @Test
    public void testAlreadyCompleteExceptionallyUnmodifiableFuture() throws Exception {
        CompletableFuture future = MoreFutures.failedFuture((Throwable)new SQLException("foo"));
        CompletableFuture unmodifiableFuture = MoreFutures.unmodifiableFuture((CompletableFuture)future);
        TestMoreFutures.assertFailure(() -> {
            String cfr_ignored_0 = (String)MoreFutures.getFutureValue((Future)future, SQLException.class);
        }, e -> {
            Assertions.assertInstanceOf((Object)e, SQLException.class);
            Assert.assertEquals((String)e.getMessage(), (String)"foo");
        });
        Assert.assertTrue((boolean)unmodifiableFuture.isDone());
        TestMoreFutures.assertFailure(() -> {
            String cfr_ignored_0 = (String)MoreFutures.getFutureValue((Future)unmodifiableFuture, SQLException.class);
        }, e -> {
            Assertions.assertInstanceOf((Object)e, SQLException.class);
            Assert.assertEquals((String)e.getMessage(), (String)"foo");
        });
    }

    @Test
    public void testFailedFuture() throws Exception {
        CompletableFuture future = MoreFutures.failedFuture((Throwable)new SQLException("foo"));
        Assert.assertTrue((boolean)future.isCompletedExceptionally());
        TestMoreFutures.assertFailure(future::get, e -> {
            Assertions.assertInstanceOf((Object)e, ExecutionException.class);
            Assert.assertTrue((boolean)(e.getCause() instanceof SQLException));
            Assert.assertEquals((String)e.getCause().getMessage(), (String)"foo");
        });
    }

    @Test
    public void testGetFutureValue() throws Exception {
        this.assertGetUnchecked(MoreFutures::getFutureValue);
    }

    @Test
    public void testGetFutureValueWithExceptionType() throws Exception {
        this.assertGetUnchecked(future -> MoreFutures.getFutureValue((Future)future, IOException.class));
        TestMoreFutures.assertFailure(() -> MoreFutures.getFutureValue((Future)MoreFutures.failedFuture((Throwable)new SQLException("foo")), SQLException.class), e -> {
            Assertions.assertInstanceOf((Object)e, SQLException.class);
            Assert.assertEquals((String)e.getMessage(), (String)"foo");
        });
    }

    @Test
    public void testTryGetFutureValue() throws Exception {
        this.assertGetUnchecked(future -> {
            Optional optional = MoreFutures.tryGetFutureValue((Future)future);
            if (optional.isPresent()) {
                return optional.get();
            }
            Assert.assertNull((Object)MoreFutures.getFutureValue((Future)future));
            return null;
        });
        Assert.assertEquals((Object)MoreFutures.tryGetFutureValue(new CompletableFuture()), Optional.empty());
    }

    @Test
    public void testTryGetFutureValueWithWait() throws Exception {
        this.assertGetUnchecked(future -> {
            Optional optional = MoreFutures.tryGetFutureValue((Future)future, (int)100, (TimeUnit)TimeUnit.MILLISECONDS);
            if (optional.isPresent()) {
                return optional.get();
            }
            Assert.assertNull((Object)MoreFutures.getFutureValue((Future)future));
            return null;
        });
        Assert.assertEquals((Object)MoreFutures.tryGetFutureValue(new CompletableFuture(), (int)10, (TimeUnit)TimeUnit.MILLISECONDS), Optional.empty());
    }

    @Test
    public void testTryGetFutureValueWithExceptionType() throws Exception {
        this.assertGetUnchecked(future -> {
            Optional optional = MoreFutures.tryGetFutureValue((Future)future, (int)100, (TimeUnit)TimeUnit.MILLISECONDS, IOException.class);
            if (optional.isPresent()) {
                return optional.get();
            }
            Assert.assertNull((Object)MoreFutures.getFutureValue((Future)future, IOException.class));
            return null;
        });
        Assert.assertEquals((Object)MoreFutures.tryGetFutureValue(new CompletableFuture(), (int)10, (TimeUnit)TimeUnit.MILLISECONDS), Optional.empty());
        TestMoreFutures.assertFailure(() -> MoreFutures.tryGetFutureValue((Future)MoreFutures.failedFuture((Throwable)new SQLException("foo")), (int)10, (TimeUnit)TimeUnit.MILLISECONDS, SQLException.class), e -> {
            Assertions.assertInstanceOf((Object)e, SQLException.class);
            Assert.assertEquals((String)e.getMessage(), (String)"foo");
        });
    }

    @Test
    public void testAnyOf() throws Exception {
        this.assertGetUnchecked(future -> MoreFutures.getFutureValue((Future)MoreFutures.firstCompletedFuture((Iterable)ImmutableList.of(new CompletableFuture(), (Object)future, new CompletableFuture()))));
        TestMoreFutures.assertFailure(() -> MoreFutures.firstCompletedFuture(null), e -> Assertions.assertInstanceOf((Object)e, NullPointerException.class));
        TestMoreFutures.assertFailure(() -> MoreFutures.firstCompletedFuture((Iterable)ImmutableList.of()), e -> Assertions.assertInstanceOf((Object)e, IllegalArgumentException.class));
        Assert.assertEquals((Object)MoreFutures.tryGetFutureValue((Future)MoreFutures.firstCompletedFuture((Iterable)ImmutableList.of(new CompletableFuture(), new CompletableFuture())), (int)10, (TimeUnit)TimeUnit.MILLISECONDS), Optional.empty());
    }

    @Test
    public void testToFromListenableFuture() throws Exception {
        this.assertGetUnchecked(future -> MoreFutures.getFutureValue((Future)MoreFutures.toCompletableFuture((ListenableFuture)MoreFutures.toListenableFuture((CompletableFuture)future))));
        SettableFuture settableFuture = SettableFuture.create();
        MoreFutures.toCompletableFuture((ListenableFuture)settableFuture).cancel(true);
        Assert.assertTrue((boolean)settableFuture.isCancelled());
        CompletableFuture completableFuture = new CompletableFuture();
        MoreFutures.toListenableFuture(completableFuture).cancel(true);
        Assert.assertTrue((boolean)completableFuture.isCancelled());
        Assert.assertEquals((Object)MoreFutures.tryGetFutureValue((Future)MoreFutures.toCompletableFuture((ListenableFuture)SettableFuture.create()), (int)10, (TimeUnit)TimeUnit.MILLISECONDS), Optional.empty());
        Assert.assertEquals((Object)MoreFutures.tryGetFutureValue((Future)MoreFutures.toListenableFuture(new CompletableFuture()), (int)10, (TimeUnit)TimeUnit.MILLISECONDS), Optional.empty());
    }

    @Test
    public void testEmptyAllAsList() throws Exception {
        CompletableFuture future = MoreFutures.allAsList((List)ImmutableList.of());
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertFalse((boolean)future.isCompletedExceptionally());
        Assert.assertFalse((boolean)future.isCancelled());
        Assert.assertEquals((Collection)((Collection)future.join()), (Collection)ImmutableList.of());
    }

    @Test
    public void testSingleElementAllAsList() throws Exception {
        CompletableFuture<String> element1 = new CompletableFuture<String>();
        CompletableFuture future = MoreFutures.allAsList((List)ImmutableList.of(element1));
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertFalse((boolean)future.isCancelled());
        element1.complete("a");
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertFalse((boolean)future.isCompletedExceptionally());
        Assert.assertFalse((boolean)future.isCancelled());
        Assert.assertEquals((Collection)((Collection)future.join()), (Collection)ImmutableList.of((Object)"a"));
    }

    @Test
    public void testExceptionalSingleElementAllAsList() throws Exception {
        CompletableFuture element1 = new CompletableFuture();
        CompletableFuture future = MoreFutures.allAsList((List)ImmutableList.of(element1));
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertFalse((boolean)future.isCancelled());
        element1.completeExceptionally(new RuntimeException());
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertTrue((boolean)future.isCompletedExceptionally());
        Assert.assertFalse((boolean)future.isCancelled());
    }

    @Test
    public void testMultipleElementAllAsList() throws Exception {
        CompletableFuture<String> element1 = new CompletableFuture<String>();
        CompletableFuture<String> element2 = new CompletableFuture<String>();
        CompletableFuture future = MoreFutures.allAsList((List)ImmutableList.of(element1, element2));
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertFalse((boolean)future.isCancelled());
        element1.complete("a");
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertFalse((boolean)future.isCompletedExceptionally());
        Assert.assertFalse((boolean)future.isCancelled());
        element2.complete("b");
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertFalse((boolean)future.isCompletedExceptionally());
        Assert.assertFalse((boolean)future.isCancelled());
        Assert.assertEquals((Collection)((Collection)future.join()), (Collection)ImmutableList.of((Object)"a", (Object)"b"));
    }

    @Test
    public void testExceptionalMultipleElementAllAsList() throws Exception {
        CompletableFuture element1 = new CompletableFuture();
        CompletableFuture element2 = new CompletableFuture();
        CompletableFuture future = MoreFutures.allAsList((List)ImmutableList.of(element1, element2));
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertFalse((boolean)future.isCompletedExceptionally());
        Assert.assertFalse((boolean)future.isCancelled());
        element1.completeExceptionally(new RuntimeException());
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertTrue((boolean)future.isCompletedExceptionally());
        Assert.assertFalse((boolean)future.isCancelled());
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableAllAsList() throws Exception {
        CompletableFuture future = MoreFutures.allAsList((List)ImmutableList.of(new CompletableFuture()));
        future.complete(null);
    }

    @Test
    public void testTimeout() throws Exception {
        CompletableFuture rootFuture = new CompletableFuture();
        CompletableFuture timeoutFuture = MoreFutures.addTimeout(rootFuture, () -> "timeout", (Duration)new Duration(0.0, TimeUnit.MILLISECONDS), (ScheduledExecutorService)this.executorService);
        Assert.assertEquals((String)((String)MoreFutures.tryGetFutureValue((Future)timeoutFuture, (int)10, (TimeUnit)TimeUnit.SECONDS).get()), (String)"timeout");
        Assert.assertTrue((boolean)timeoutFuture.isDone());
        Assert.assertFalse((boolean)timeoutFuture.isCancelled());
        Assert.assertTrue((boolean)rootFuture.isDone());
        Assert.assertTrue((boolean)rootFuture.isCancelled());
    }

    @Test
    public void testTimeoutExceptionValue() throws Exception {
        CompletableFuture rootFuture = new CompletableFuture();
        CompletableFuture timeoutFuture = MoreFutures.addTimeout(rootFuture, () -> {
            throw new SQLException("timeout");
        }, (Duration)new Duration(0.0, TimeUnit.MILLISECONDS), (ScheduledExecutorService)this.executorService);
        TestMoreFutures.assertFailure(() -> MoreFutures.tryGetFutureValue((Future)timeoutFuture, (int)10, (TimeUnit)TimeUnit.SECONDS, SQLException.class), e -> {
            Assertions.assertInstanceOf((Object)e, SQLException.class);
            Assert.assertEquals((String)e.getMessage(), (String)"timeout");
        });
        Assert.assertTrue((boolean)timeoutFuture.isDone());
        Assert.assertFalse((boolean)timeoutFuture.isCancelled());
        Assert.assertTrue((boolean)rootFuture.isDone());
        Assert.assertTrue((boolean)rootFuture.isCancelled());
    }

    @Test
    public void testTimeoutCancel() throws Exception {
        CompletableFuture rootFuture = new CompletableFuture();
        CompletableFuture timeoutFuture = MoreFutures.addTimeout(rootFuture, () -> "timeout", (Duration)new Duration(10.0, TimeUnit.SECONDS), (ScheduledExecutorService)this.executorService);
        Assert.assertEquals((Object)MoreFutures.tryGetFutureValue((Future)timeoutFuture, (int)10, (TimeUnit)TimeUnit.MILLISECONDS), Optional.empty());
        Assert.assertTrue((boolean)timeoutFuture.cancel(true));
        Assert.assertTrue((boolean)timeoutFuture.isDone());
        Assert.assertTrue((boolean)timeoutFuture.isCancelled());
        Assert.assertTrue((boolean)rootFuture.isDone());
        Assert.assertTrue((boolean)rootFuture.isCancelled());
    }

    public void assertGetUnchecked(UncheckedGetter getter) throws Exception {
        TestMoreFutures.assertGetUncheckedInternal(getter);
        TestMoreFutures.assertGetUncheckedInternal(future -> getter.get(MoreFutures.addTimeout((CompletableFuture)future, () -> {
            throw new RuntimeException("timeout");
        }, (Duration)new Duration(10.0, TimeUnit.SECONDS), (ScheduledExecutorService)this.executorService)));
    }

    public static void assertGetUncheckedInternal(UncheckedGetter getter) throws Exception {
        Assert.assertEquals((Object)getter.get(CompletableFuture.completedFuture("foo")), (Object)"foo");
        TestMoreFutures.assertFailure(() -> getter.get(MoreFutures.failedFuture((Throwable)new IllegalArgumentException("foo"))), e -> {
            Assertions.assertInstanceOf((Object)e, IllegalArgumentException.class);
            Assert.assertEquals((String)e.getMessage(), (String)"foo");
        });
        TestMoreFutures.assertFailure(() -> getter.get(MoreFutures.failedFuture((Throwable)new SQLException("foo"))), e -> {
            Assertions.assertInstanceOf((Object)e, RuntimeException.class);
            Assertions.assertInstanceOf((Object)e.getCause(), SQLException.class);
            Assert.assertEquals((String)e.getCause().getMessage(), (String)"foo");
        });
        Thread.currentThread().interrupt();
        TestMoreFutures.assertFailure(() -> getter.get(new CompletableFuture<Object>()), e -> {
            Assertions.assertInstanceOf((Object)e, RuntimeException.class);
            Assertions.assertInstanceOf((Object)e.getCause(), InterruptedException.class);
            Assert.assertTrue((boolean)Thread.interrupted());
        });
        Assert.assertFalse((boolean)Thread.currentThread().isInterrupted());
        CompletableFuture canceledFuture = new CompletableFuture();
        canceledFuture.cancel(true);
        TestMoreFutures.assertFailure(() -> getter.get(canceledFuture), e -> Assertions.assertInstanceOf((Object)e, CancellationException.class));
        Assert.assertEquals((Object)getter.get(CompletableFuture.completedFuture(null)), null);
    }

    private static void assertFailure(Thrower thrower, Consumer<Throwable> verifier) {
        try {
            thrower.execute();
        }
        catch (Throwable throwable) {
            verifier.accept(throwable);
            return;
        }
        Assert.fail((String)"expected exception to be thrown");
    }

    private static interface Thrower {
        public void execute() throws Throwable;
    }

    private static interface UncheckedGetter {
        public Object get(CompletableFuture<Object> var1) throws Exception;
    }
}

