/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.concurrent;

import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.concurrent.BoundedExecutor;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestBoundedExecutor {
    private ExecutorService executorService;

    @BeforeClass
    public void setUp() throws Exception {
        this.executorService = Executors.newCachedThreadPool();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this.executorService.shutdownNow();
    }

    @Test
    public void testCounter() throws Exception {
        BoundedExecutor boundedExecutor = new BoundedExecutor((Executor)this.executorService, 1);
        int totalTasks = 100000;
        final AtomicInteger counter = new AtomicInteger();
        final CountDownLatch startLatch = new CountDownLatch(1);
        final CountDownLatch completeLatch = new CountDownLatch(totalTasks);
        for (int i = 0; i < totalTasks; ++i) {
            boundedExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Uninterruptibles.awaitUninterruptibly((CountDownLatch)startLatch);
                        int initialCount = counter.get();
                        counter.set(initialCount + 1);
                    }
                    finally {
                        completeLatch.countDown();
                    }
                }
            });
        }
        startLatch.countDown();
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)completeLatch, (long)1L, (TimeUnit)TimeUnit.MINUTES);
        Assert.assertEquals((int)counter.get(), (int)totalTasks);
    }

    @Test
    public void testSingleThreadBound() throws Exception {
        this.testBound(1, 100000);
    }

    @Test
    public void testDoubleThreadBound() throws Exception {
        this.testBound(2, 100000);
    }

    private void testBound(final int maxThreads, int totalTasks) {
        BoundedExecutor boundedExecutor = new BoundedExecutor((Executor)this.executorService, maxThreads);
        final AtomicInteger activeThreadCount = new AtomicInteger();
        final CountDownLatch startLatch = new CountDownLatch(1);
        final CountDownLatch completeLatch = new CountDownLatch(totalTasks);
        final AtomicBoolean failed = new AtomicBoolean();
        for (int i = 0; i < totalTasks; ++i) {
            boundedExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Uninterruptibles.awaitUninterruptibly((CountDownLatch)startLatch);
                        int count = activeThreadCount.incrementAndGet();
                        if (count < 1 || count > maxThreads) {
                            failed.set(true);
                        }
                        activeThreadCount.decrementAndGet();
                    }
                    finally {
                        completeLatch.countDown();
                    }
                }
            });
        }
        startLatch.countDown();
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)completeLatch, (long)1L, (TimeUnit)TimeUnit.MINUTES);
        Assert.assertFalse((boolean)failed.get());
    }
}

