/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.command;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.command.Command;
import io.airlift.command.CommandFailedException;
import io.airlift.command.CommandTimeoutException;
import io.airlift.concurrent.Threads;
import io.airlift.testing.EquivalenceTester;
import io.airlift.units.Duration;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestCommand {
    private ExecutorService executor;

    @BeforeClass
    public void setUp() throws Exception {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"process-input-reader-%s"));
    }

    @AfterClass
    public void tearDown() throws Exception {
        this.executor.shutdownNow();
    }

    @Test
    public void buildCommandChainNewObjects() throws Exception {
        Command command = new Command(new String[]{"foo"});
        Assert.assertNotSame((Object)command.setDirectory("foo"), (Object)command);
        Assert.assertNotSame((Object)command.setDirectory(new File("foo")), (Object)command);
        Assert.assertNotSame((Object)command.setSuccessfulExitCodes(new int[]{42}), (Object)command);
        Assert.assertNotSame((Object)command.setSuccessfulExitCodes((Set)ImmutableSet.of((Object)42)), (Object)command);
        Assert.assertNotSame((Object)command.setTimeLimit(2.0, TimeUnit.SECONDS), (Object)command);
        Assert.assertNotSame((Object)command.setTimeLimit(new Duration(2.0, TimeUnit.SECONDS)), (Object)command);
    }

    @Test
    public void buildCommand() throws Exception {
        Command expected = new Command(new String[]{"a", "b", "c"}).setDirectory("directory").setSuccessfulExitCodes(new int[]{33, 44}).setTimeLimit(5.0, TimeUnit.SECONDS);
        Command actual = new Command(new String[]{"a", "b", "c"}).setDirectory("directory").setSuccessfulExitCodes(new int[]{33, 44}).setTimeLimit(5.0, TimeUnit.SECONDS);
        Assert.assertEquals((Object)actual, (Object)expected);
        Assert.assertNotSame((Object)actual.setDirectory("foo"), (Object)actual);
        Assert.assertEquals((Object)actual, (Object)expected);
        Assert.assertNotSame((Object)actual.setDirectory(new File("foo")), (Object)actual);
        Assert.assertEquals((Object)actual, (Object)expected);
        Assert.assertNotSame((Object)actual.setSuccessfulExitCodes(new int[]{42}), (Object)actual);
        Assert.assertEquals((Object)actual, (Object)expected);
        Assert.assertNotSame((Object)actual.setSuccessfulExitCodes((Set)ImmutableSet.of((Object)42)), (Object)actual);
        Assert.assertEquals((Object)actual, (Object)expected);
        Assert.assertNotSame((Object)actual.setTimeLimit(2.0, TimeUnit.SECONDS), (Object)actual);
        Assert.assertEquals((Object)actual, (Object)expected);
        Assert.assertNotSame((Object)actual.setTimeLimit(new Duration(2.0, TimeUnit.SECONDS)), (Object)actual);
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testGetters() throws Exception {
        Command command = new Command(new String[]{"a", "b", "c"}).setDirectory("directory").setSuccessfulExitCodes(new int[]{33, 44}).setTimeLimit(5.0, TimeUnit.SECONDS);
        Assert.assertEquals((Collection)command.getCommand(), (Collection)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        Assert.assertEquals((Object)command.getDirectory(), (Object)new File("directory"));
        Assert.assertEquals((Set)command.getSuccessfulExitCodes(), (Set)ImmutableSet.of((Object)44, (Object)33));
        Assert.assertEquals((Object)command.getTimeLimit(), (Object)new Duration(5.0, TimeUnit.SECONDS));
    }

    @Test
    public void execSimple() throws Exception {
        int actual = new Command(new String[]{"bash", "-c", "set"}).setTimeLimit(1.0, TimeUnit.SECONDS).execute((Executor)this.executor).getExitCode();
        Assert.assertEquals((int)actual, (int)0);
    }

    @Test(expectedExceptions={CommandTimeoutException.class})
    public void execTimeout() throws Exception {
        new Command(new String[]{"bash", "-c", "echo foo && sleep 15"}).setTimeLimit(1.0, TimeUnit.SECONDS).execute((Executor)this.executor);
    }

    @Test(expectedExceptions={CommandFailedException.class})
    public void execBadExitCode() throws Exception {
        new Command(new String[]{"bash", "-c", "exit 33"}).setTimeLimit(1.0, TimeUnit.SECONDS).execute((Executor)this.executor);
    }

    @Test
    public void execNonZeroSuccess() throws Exception {
        int actual = new Command(new String[]{"bash", "-c", "exit 33"}).setSuccessfulExitCodes(new int[]{33}).setTimeLimit(1.0, TimeUnit.SECONDS).execute((Executor)this.executor).getExitCode();
        Assert.assertEquals((int)actual, (int)33);
    }

    @Test(expectedExceptions={CommandFailedException.class})
    public void execZeroExitFail() throws Exception {
        new Command(new String[]{"bash", "-c", "exit 0"}).setSuccessfulExitCodes(new int[]{33}).setTimeLimit(1.0, TimeUnit.SECONDS).execute((Executor)this.executor);
    }

    @Test(expectedExceptions={CommandFailedException.class})
    public void execBogusProcess() throws Exception {
        new Command(new String[]{"ab898wer98e7r98e7r98e7r98ew"}).setTimeLimit(1.0, TimeUnit.SECONDS).execute((Executor)this.executor);
    }

    @Test
    public void testEquivalence() {
        EquivalenceTester.equivalenceTester().addEquivalentGroup((Object)new Command(new String[]{"command"}), new Object[]{new Command(new String[]{"command"})}).addEquivalentGroup((Object)new Command(new String[]{"command"}).setDirectory("foo"), new Object[]{new Command(new String[]{"command"}).setDirectory(new File("foo"))}).addEquivalentGroup((Object)new Command(new String[]{"command"}).setTimeLimit(5.0, TimeUnit.SECONDS), new Object[]{new Command(new String[]{"command"}).setTimeLimit(new Duration(5.0, TimeUnit.SECONDS))}).addEquivalentGroup((Object)new Command(new String[]{"command"}).setSuccessfulExitCodes(new int[]{5, 6}), new Object[]{new Command(new String[]{"command"}).setSuccessfulExitCodes((Set)ImmutableSet.of((Object)6, (Object)5))}).check();
    }
}

