/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.common.collect.ImmutableMap;
import com.google.inject.ConfigurationException;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.google.inject.spi.Message;
import io.airlift.bootstrap.ApplicationConfigurationException;
import io.airlift.bootstrap.Bootstrap;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBootstrap {
    @Test
    public void testRequiresExplicitBindings() {
        Bootstrap bootstrap = new Bootstrap(new Module[0]);
        try {
            bootstrap.initialize().getInstance(Instance.class);
            Assert.fail((String)"should require explicit bindings");
        }
        catch (ConfigurationException e) {
            io.airlift.testing.Assertions.assertContains((String)((Message)e.getErrorMessages().iterator().next()).getMessage(), (String)"Explicit bindings are required");
        }
    }

    @Test
    public void testDoesNotAllowCircularDependencies() {
        Bootstrap bootstrap = new Bootstrap(new Module[]{binder -> {
            binder.bind(InstanceA.class);
            binder.bind(InstanceB.class);
        }});
        try {
            bootstrap.initialize().getInstance(InstanceA.class);
            Assert.fail((String)"should not allow circular dependencies");
        }
        catch (ProvisionException e) {
            io.airlift.testing.Assertions.assertContains((String)((Message)e.getErrorMessages().iterator().next()).getMessage(), (String)"circular dependencies are disabled");
        }
    }

    @Test
    public void testEnvironmentVariableReplacement() {
        ImmutableMap original = ImmutableMap.builder().put((Object)"apple", (Object)"apple-value").put((Object)"grape", (Object)"${ENV:GRAPE}").put((Object)"peach", (Object)"${ENV:PEACH}").put((Object)"grass", (Object)"${ENV:!!!}").put((Object)"pear", (Object)"${ENV:X_PEAR}").put((Object)"cherry", (Object)"${ENV:X_CHERRY}").put((Object)"orange", (Object)"orange-value").put((Object)"watermelon", (Object)"${ENV:WATER}${ENV:MELON}").put((Object)"blueberry", (Object)"${ENV:BLUE}${ENV:BERRY}").put((Object)"contaminated-lemon", (Object)"${ENV:!!!}${ENV:LEMON}").put((Object)"mixed-fruit", (Object)"mango-value:${ENV:BANANA}:${ENV:COCONUT}").put((Object)"no-recursive-replacement", (Object)"${ENV:FIRST}, ${ENV:SECOND}").build();
        ImmutableMap environment = ImmutableMap.builder().put((Object)"GRAPE", (Object)"env-grape").put((Object)"X_CHERRY", (Object)"env-cherry").put((Object)"WATER", (Object)"env-water").put((Object)"MELON", (Object)"env-melon").put((Object)"BERRY", (Object)"env-berry").put((Object)"LEMON", (Object)"env-lemon").put((Object)"BANANA", (Object)"env-banana").put((Object)"COCONUT", (Object)"env-coconut").put((Object)"FIRST", (Object)"env-first:${ENV:SECOND}:").put((Object)"SECOND", (Object)"env-second:${ENV:FIRST}").build();
        ArrayList errors = new ArrayList();
        Map actual = Bootstrap.replaceEnvironmentVariables((Map)original, (Map)environment, (key, error) -> errors.add(error));
        ImmutableMap expected = ImmutableMap.builder().put((Object)"apple", (Object)"apple-value").put((Object)"grape", (Object)"env-grape").put((Object)"grass", (Object)"${ENV:!!!}").put((Object)"cherry", (Object)"env-cherry").put((Object)"orange", (Object)"orange-value").put((Object)"watermelon", (Object)"env-waterenv-melon").put((Object)"contaminated-lemon", (Object)"${ENV:!!!}env-lemon").put((Object)"mixed-fruit", (Object)"mango-value:env-banana:env-coconut").put((Object)"no-recursive-replacement", (Object)"env-first:${ENV:SECOND}:, env-second:${ENV:FIRST}").build();
        Assert.assertEquals((Map)actual, (Map)expected);
        Assertions.assertThat(errors).containsExactly((Object[])new String[]{"Configuration property 'peach' references unset environment variable 'PEACH'", "Configuration property 'pear' references unset environment variable 'X_PEAR'", "Configuration property 'blueberry' references unset environment variable 'BLUE'"});
    }

    @Test
    public void testStrictConfig() {
        Bootstrap bootstrap = new Bootstrap(new Module[0]).setRequiredConfigurationProperty("test-required", "foo");
        Assertions.assertThatThrownBy(() -> ((Bootstrap)bootstrap).initialize()).isInstanceOfSatisfying(ApplicationConfigurationException.class, e -> Assertions.assertThat((Iterable)e.getErrors()).containsExactly((Object[])new Message[]{new Message("Configuration property 'test-required' was not used")}));
    }

    @Test
    public void testNonStrictConfig() {
        new Bootstrap(new Module[0]).setRequiredConfigurationProperty("test-required", "foo").nonStrictConfig().initialize();
    }

    public static class InstanceB {
        @Inject
        public InstanceB(InstanceA a) {
        }
    }

    public static class InstanceA {
        @Inject
        public InstanceA(InstanceB b) {
        }
    }

    public static class Instance {
    }
}

