/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import io.airlift.bootstrap.ColumnPrinter;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.bootstrap.LifeCycleModule;
import io.airlift.bootstrap.LoggingWriter;
import io.airlift.configuration.ConfigurationAwareModule;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ConfigurationInspector;
import io.airlift.configuration.ConfigurationLoader;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.configuration.ConfigurationValidator;
import io.airlift.configuration.ValidationErrorModule;
import io.airlift.configuration.WarningsMonitor;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.airlift.log.LoggingConfiguration;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class Bootstrap {
    private final Logger log = Logger.get((String)"Bootstrap");
    private final List<Module> modules;
    private Map<String, String> requiredConfigurationProperties;
    private Map<String, String> optionalConfigurationProperties;
    private boolean initializeLogging = true;
    private boolean quiet;
    private boolean strictConfig;
    private boolean requireExplicitBindings = true;
    private boolean initialized;
    private static final String PROPERTY_NAME_COLUMN = "PROPERTY";
    private static final String DEFAULT_VALUE_COLUMN = "DEFAULT";
    private static final String CURRENT_VALUE_COLUMN = "RUNTIME";
    private static final String DESCRIPTION_COLUMN = "DESCRIPTION";

    public Bootstrap(Module ... modules) {
        this((Iterable<? extends Module>)ImmutableList.copyOf((Object[])modules));
    }

    public Bootstrap(Iterable<? extends Module> modules) {
        this.modules = ImmutableList.copyOf(modules);
    }

    @Beta
    public Bootstrap setRequiredConfigurationProperty(String key, String value) {
        if (this.requiredConfigurationProperties == null) {
            this.requiredConfigurationProperties = new TreeMap<String, String>();
        }
        this.requiredConfigurationProperties.put(key, value);
        return this;
    }

    @Beta
    public Bootstrap setRequiredConfigurationProperties(Map<String, String> requiredConfigurationProperties) {
        if (this.requiredConfigurationProperties == null) {
            this.requiredConfigurationProperties = new TreeMap<String, String>();
        }
        this.requiredConfigurationProperties.putAll(requiredConfigurationProperties);
        return this;
    }

    @Beta
    public Bootstrap setOptionalConfigurationProperty(String key, String value) {
        if (this.optionalConfigurationProperties == null) {
            this.optionalConfigurationProperties = new TreeMap<String, String>();
        }
        this.optionalConfigurationProperties.put(key, value);
        return this;
    }

    @Beta
    public Bootstrap setOptionalConfigurationProperties(Map<String, String> optionalConfigurationProperties) {
        if (this.optionalConfigurationProperties == null) {
            this.optionalConfigurationProperties = new TreeMap<String, String>();
        }
        this.optionalConfigurationProperties.putAll(optionalConfigurationProperties);
        return this;
    }

    @Beta
    public Bootstrap doNotInitializeLogging() {
        this.initializeLogging = false;
        return this;
    }

    public Bootstrap quiet() {
        this.quiet = true;
        return this;
    }

    public Bootstrap strictConfig() {
        this.strictConfig = true;
        return this;
    }

    public Bootstrap requireExplicitBindings(boolean requireExplicitBindings) {
        this.requireExplicitBindings = requireExplicitBindings;
        return this;
    }

    public Injector initialize() throws Exception {
        Map requiredProperties;
        Preconditions.checkState((!this.initialized ? 1 : 0) != 0, (Object)"Already initialized");
        this.initialized = true;
        Logging logging = null;
        if (this.initializeLogging) {
            logging = Logging.initialize();
        }
        Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                Bootstrap.this.log.error(e, "Uncaught exception in thread %s", new Object[]{t.getName()});
            }
        });
        if (this.requiredConfigurationProperties == null) {
            this.log.info("Loading configuration");
            ConfigurationLoader loader = new ConfigurationLoader();
            requiredProperties = Collections.emptyMap();
            String configFile = System.getProperty("config");
            if (configFile != null) {
                requiredProperties = loader.loadPropertiesFrom(configFile);
            }
        } else {
            requiredProperties = this.requiredConfigurationProperties;
        }
        TreeMap properties = Maps.newTreeMap();
        if (this.optionalConfigurationProperties != null) {
            properties.putAll(this.optionalConfigurationProperties);
        }
        properties.putAll(requiredProperties);
        properties.putAll(Maps.fromProperties((Properties)System.getProperties()));
        properties = ImmutableSortedMap.copyOf((Map)properties);
        ConfigurationFactory configurationFactory = new ConfigurationFactory((Map)properties);
        if (logging != null) {
            this.log.info("Initializing logging");
            LoggingConfiguration configuration = (LoggingConfiguration)configurationFactory.build(LoggingConfiguration.class);
            logging.configure(configuration);
        }
        final WarningsMonitor warningsMonitor = new WarningsMonitor(){

            public void onWarning(String message) {
                Bootstrap.this.log.warn(message);
            }
        };
        for (Module module : this.modules) {
            if (!(module instanceof ConfigurationAwareModule)) continue;
            ConfigurationAwareModule configurationAwareModule = (ConfigurationAwareModule)module;
            configurationAwareModule.setConfigurationFactory(configurationFactory);
        }
        ConfigurationValidator configurationValidator = new ConfigurationValidator(configurationFactory, warningsMonitor);
        List messages = configurationValidator.validate(this.modules);
        final TreeMap unusedProperties = Maps.newTreeMap();
        unusedProperties.putAll(requiredProperties);
        unusedProperties.keySet().removeAll(configurationFactory.getUsedProperties());
        if (!this.quiet) {
            this.logConfiguration(configurationFactory, unusedProperties);
        }
        ImmutableList.Builder moduleList = ImmutableList.builder();
        moduleList.add((Object)new LifeCycleModule());
        moduleList.add((Object)new ConfigurationModule(configurationFactory));
        if (!messages.isEmpty()) {
            moduleList.add((Object)new ValidationErrorModule(messages));
        }
        moduleList.add((Object)new Module(){

            public void configure(Binder binder) {
                binder.bind(WarningsMonitor.class).toInstance((Object)warningsMonitor);
            }
        });
        moduleList.add((Object)new Module(){

            public void configure(Binder binder) {
                binder.disableCircularProxies();
                if (Bootstrap.this.requireExplicitBindings) {
                    binder.requireExplicitBindings();
                }
            }
        });
        if (this.strictConfig) {
            moduleList.add((Object)new Module(){

                public void configure(Binder binder) {
                    for (Map.Entry unusedProperty : unusedProperties.entrySet()) {
                        binder.addError("Configuration property '%s=%s' was not used", new Object[]{unusedProperty.getKey(), unusedProperty.getValue()});
                    }
                }
            });
        }
        moduleList.addAll(this.modules);
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Iterable)moduleList.build());
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        if (lifeCycleManager.size() > 0) {
            lifeCycleManager.start();
        }
        return injector;
    }

    private void logConfiguration(ConfigurationFactory configurationFactory, Map<String, String> unusedProperties) {
        ColumnPrinter columnPrinter = this.makePrinterForConfiguration(configurationFactory);
        try (PrintWriter out = new PrintWriter(new LoggingWriter(this.log, LoggingWriter.Type.INFO));){
            columnPrinter.print(out);
        }
        if (!unusedProperties.isEmpty()) {
            this.log.warn("UNUSED PROPERTIES");
            for (Map.Entry<String, String> unusedProperty : unusedProperties.entrySet()) {
                this.log.warn("%s=%s", new Object[]{unusedProperty.getKey(), unusedProperty.getValue()});
            }
            this.log.warn("");
        }
    }

    private ColumnPrinter makePrinterForConfiguration(ConfigurationFactory configurationFactory) {
        ConfigurationInspector configurationInspector = new ConfigurationInspector();
        ColumnPrinter columnPrinter = new ColumnPrinter();
        columnPrinter.addColumn(PROPERTY_NAME_COLUMN);
        columnPrinter.addColumn(DEFAULT_VALUE_COLUMN);
        columnPrinter.addColumn(CURRENT_VALUE_COLUMN);
        columnPrinter.addColumn(DESCRIPTION_COLUMN);
        for (ConfigurationInspector.ConfigRecord record : configurationInspector.inspect(configurationFactory)) {
            for (ConfigurationInspector.ConfigAttribute attribute : record.getAttributes()) {
                columnPrinter.addValue(PROPERTY_NAME_COLUMN, attribute.getPropertyName());
                columnPrinter.addValue(DEFAULT_VALUE_COLUMN, attribute.getDefaultValue());
                columnPrinter.addValue(CURRENT_VALUE_COLUMN, attribute.getCurrentValue());
                columnPrinter.addValue(DESCRIPTION_COLUMN, attribute.getDescription());
            }
        }
        return columnPrinter;
    }
}

